<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

WpBookingProHtmlFrontend::load_jquery_library('slick');
WpBookingProHtmlFrontend::load_jquery_library('validate');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');
WpBookingProHtmlFrontend::load_jquery_library('awesome');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');
WpBookingProHtmlFrontend::load_jquery_library('select2');

$doc = FactoryAlias::getDocument();
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addLessStyleSheet('frontend/app/assets/less/view_user_account.less');
$uri = FactoryAlias::getUri();
$layout = $uri->getVar('layout', 'profile-user');
$order_id = $uri->getVar('order_id', '');
$form = $uri->getVar('form', '');
$category_id = $uri->getVar('category_id', '');
$service_id = $uri->getVar('service_id', '');
$employee_id = $uri->getVar('employee_id', '');
$reviews_id = $uri->getVar('review_id', '');
$location_id = $uri->getVar('location_id', '');
$state_id = $uri->getVar('state_id', '');
$customer_id = $uri->getVar('customer_id', '');

$page_user_account = ConfigHelperAlias::get_page_user_account();
if ($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
} else {
    $this->page_user_account = "";
}
$page_login = ConfigHelperAlias::get_page_login();
if ($page_login) {
    $this->page_login = get_page_link($page_login);
} else {
    $this->page_login = "";
}

$user = $this->user;

?>
    <div class="view-user-account">
        <?php if (is_user_logged_in()) { ?>
            <form action="" method="post" name="form-account" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-md-3">
                        <div class="side-navigation">
                            <div class="info-main">
                                <div class="profile-img">
                                    <div>
                                        <img src="<?php echo(esc_url(isset($user->data->user_plugin->image) ? $user->data->user_plugin->image : '')) ?>"
                                             alt="profile-picture">
                                    </div>
                                </div>
                                <h3><?php echo(esc_html($user->data->display_name)) ?></h3>
                                <p>@<?php echo(esc_html($user->data->user_login)) ?></p>
                                <button type="button"
                                        class="btn-signout"><?php esc_html_e('Sign out', 'wpbookingpro'); ?></button>
                            </div>
                            <div class="profile-navigation">
                                <div class="block-separator">
                                    <p><?php esc_html_e('Profile', 'wpbookingpro'); ?></p>
                                    <div class="line"></div>
                                </div>
                                <div class="block-profile-navigation">
                                    <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'profile-user'||$layout == ''?'active':''))?>">
                                        <i class="fas fa-user"></i>
                                        <a href="<?php echo(esc_url($this->page_user_account . '?layout=profile-user')) ?>"><?php esc_html_e('My Profile', 'wpbookingpro'); ?></a>
                                    </div>
                                    <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'account-setting'?'active':''))?>">
                                        <i class="fas fa-cog"></i>
                                        <a href="<?php echo(esc_url($this->page_user_account . '?layout=account-setting')) ?>"><?php esc_html_e('Account Settings', 'wpbookingpro'); ?></a>
                                    </div>
                                    <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-order'?'active':''))?>">
                                        <i class="fas fa-shopping-cart"></i>
                                        <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-order')) ?>"><?php esc_html_e('My Orders', 'wpbookingpro'); ?></a>
                                    </div>
                                    <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'wishlist'?'active':''))?>">
                                        <i class="fas fa-heart"></i>
                                        <a href="<?php echo(esc_url($this->page_user_account . '?layout=wishlist')) ?>"><?php esc_html_e('Wish list', 'wpbookingpro'); ?></a>
                                    </div>
                                    <?php if($user->data->user_plugin->group_user_alias == 'vendor') {?>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-category'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-category')) ?>"><?php esc_html_e('My Category', 'wpbookingpro'); ?></a>
                                        </div>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-service'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-service')) ?>"><?php esc_html_e('My Service', 'wpbookingpro'); ?></a>
                                        </div>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-employee'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-employee')) ?>"><?php esc_html_e('My Employee', 'wpbookingpro'); ?></a>
                                        </div>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-review'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-review')) ?>"><?php esc_html_e('My Review', 'wpbookingpro'); ?></a>
                                        </div>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-location'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-location')) ?>"><?php esc_html_e('My Location', 'wpbookingpro'); ?></a>
                                        </div>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-state'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-state')) ?>"><?php esc_html_e('My State', 'wpbookingpro'); ?></a>
                                        </div>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-customer'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-customer')) ?>"><?php esc_html_e('My Customers', 'wpbookingpro'); ?></a>
                                        </div>
                                        <div class="block-profile-navigation-item <?php echo (esc_attr($layout == 'my-coupon'?'active':''))?>">
                                            <i class="fas fa-th-list"></i>
                                            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-coupon')) ?>"><?php esc_html_e('My Coupon', 'wpbookingpro'); ?></a>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="wrapper-content-profile">
                            <?php if ($layout == 'profile-user') { ?>
                                <?php $this->loadTemplate('profile_user') ?>
                            <?php } else if ($layout == 'account-setting') { ?>
                                <?php $this->loadTemplate('account_setting') ?>
                            <?php } else if ($layout == 'my-order') { ?>
                                <?php if ($order_id != '') { ?>
                                    <?php $this->loadTemplate('order_detail') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_order') ?>
                                <?php } ?>
                            <?php } else if ($layout == 'wishlist') { ?>
                                <?php $this->loadTemplate('wishlist') ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-category') { ?>
                                <?php if ($form == 'category_form') { ?>
                                    <?php $this->loadTemplate('category_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_category') ?>
                                <?php } ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-service') { ?>
                                <?php if ($form == 'service_form') { ?>
                                    <?php $this->loadTemplate('service_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_service') ?>
                                <?php } ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-employee') { ?>
                                <?php if ($form == 'employee_form') { ?>
                                    <?php $this->loadTemplate('employee_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_employee') ?>
                                <?php } ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-review') { ?>
                                <?php if ($form == 'review_form') { ?>
                                    <?php $this->loadTemplate('review_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_review') ?>
                                <?php } ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-location') { ?>
                                <?php if ($form == 'location_form') { ?>
                                    <?php $this->loadTemplate('location_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_location') ?>
                                <?php } ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-state') { ?>
                                <?php if ($form == 'state_form') { ?>
                                    <?php $this->loadTemplate('state_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_state') ?>
                                <?php } ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-customer') { ?>
                                <?php if ($form == 'customer_form') { ?>
                                    <?php $this->loadTemplate('customer_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_customer') ?>
                                <?php } ?>
                            <?php } else if ($user->data->user_plugin->group_user_alias == 'vendor' && $layout == 'my-coupon') { ?>
                                <?php if ($form == 'coupon_form') { ?>
                                    <?php $this->loadTemplate('coupon_form') ?>
                                <?php } else { ?>
                                    <?php $this->loadTemplate('my_coupon') ?>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="task" value="">
                <input type="hidden" name="page_login" value="<?php echo (esc_attr($this->page_login))?>">
            </form>
        <?php } else { ?>
            <?php Utility::redirect($this->page_login); ?>
        <?php } ?>
    </div>

<?php
$doc->addScriptApplySelector('.view-user-account', 'view_user_account', array(), 'frontend/app/assets/js/view_user_account.js');