<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingProFrontend\app\helpers\ConfigHelper;

WpBookingProHtmlFrontend::load_jquery_library('slick');
WpBookingProHtmlFrontend::load_jquery_library('validate');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');
WpBookingProHtmlFrontend::load_jquery_library('awesome');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');


$coupon_item = $this->coupon_item;

?>
<div class="wrapper-coupon-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Coupon Form','wpbookingpro');?></h2>
        <ul class="room-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                                      data-toggle="tab"> <?php esc_html_e('Details coupon', 'wpbookingpro') ?></a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">

                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_coupon->setValue('name',null, isset($coupon_item->name)?$coupon_item->name:'');
                        echo($this->form_coupon->renderField('name'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_coupon->setValue('code',null, isset($coupon_item->code)?$coupon_item->code:'');
                        echo($this->form_coupon->renderField('code'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_coupon->setValue('amount',null, isset($coupon_item->amount)?$coupon_item->amount:'');
                        echo($this->form_coupon->renderField('amount'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_coupon->setValue('percent',null, isset($coupon_item->percent)?$coupon_item->percent:'');
                        echo($this->form_coupon->renderField('percent'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_coupon->setValue('service_id',null, isset($coupon_item->service_id)?$coupon_item->service_id:array());
                        echo($this->form_coupon->renderField('service_id'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field  = $this->form_coupon->getField('published');
                        $field->setValue( isset($coupon_item->published)?$coupon_item->published:0);
                        echo($field->input);
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_coupon->setValue('description',null, isset($coupon_item->description)?$coupon_item->description:'');
                        echo($this->form_coupon->renderField('description'))
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-coupon'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-coupon" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>
    </div>

        <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
        <input type="hidden" name="link_redirect" value="<?php echo (esc_url($this->page_user_account.'?layout=my-coupon'));?>">


</div>
