<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingProFrontend\app\helpers\ConfigHelper;

WpBookingProHtmlFrontend::load_jquery_library('slick');
WpBookingProHtmlFrontend::load_jquery_library('validate');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');
WpBookingProHtmlFrontend::load_jquery_library('awesome');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');

$page_list_category= ConfigHelper::get_page_list_category();
if($page_list_category) {
    $this->page_list_category = get_page_link($page_list_category);
}else{
    $this->page_list_category="";
}

$category_item = $this->category_item;

?>
<div class="wrapper-category-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Category Form','wpbookingpro');?></h2>
        <ul class="room-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab"
                                                      data-toggle="tab"> <?php esc_html_e('Details Category', 'wpbookingpro') ?></a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field = $this->form_category->getField('image');
                        $field->setValue(isset($category_item->image)?$category_item->image:'');
                        echo($this->form_category->renderField('image'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_category->setValue('name',null, isset($category_item->name)?$category_item->name:'');
                        echo($this->form_category->renderField('name'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_category->setValue('published',null, isset($category_item->published)?$category_item->published:'');
                        echo($this->form_category->renderField('published'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_category->setValue('description',null, isset($category_item->description)?$category_item->description:'');
                        echo($this->form_category->renderField('description'))
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-category'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-category" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>
    </div>

        <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
        <input type="hidden" name="link_redirect" value="<?php echo (esc_url($this->page_user_account.'?layout=my-category'));?>">


</div>
