<?php
$user = $this->user;

?>
<div class="wrapper-account-setting">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Account settings','wpbookingpro');?></h2>
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#personal-info"><?php esc_html_e('Personal info','wpbookingpro');?></a></li>
            <li><a data-toggle="tab" href="#change-paswword"><?php esc_html_e('Change password','wpbookingpro');?></a></li>
            <li><a data-toggle="tab" href="#billing-address"><?php esc_html_e('Billing Address','wpbookingpro');?></a></li>
            <?php if($user->data->user_plugin->group_user_alias == 'vendor') {?>
                <li><a data-toggle="tab" href="#banner-graphic"><?php esc_html_e('Banner Graphic','wpbookingpro');?></a></li>
            <?php }?>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div id="personal-info" class="tab-pane fade in active">
                <h3><?php esc_html_e('General','wpbookingpro');?></h3>
                <p><?php esc_html_e('Setup your general profile details','wpbookingpro');?></p>
                <div class="block-edit-account">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="wrapper-account-detail">
                                <?php
                                    $this->form->setValue('first_name',null, isset($user->data->user_plugin->first_name)? $user->data->user_plugin->first_name:'');
                                    echo ($this->form->renderField('first_name'));
                                ?>
                                <?php
                                $this->form->setValue('last_name',null, $user->data->user_plugin->last_name);
                                echo ($this->form->renderField('last_name'));
                                ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php
                                $this->form->setValue('user_name',null, $user->data->user_login);
                                echo ($this->form->renderField('user_name'));
                                ?>
                                <?php
                                $this->form->setValue('email',null, $user->data->user_plugin->email);
                                echo ($this->form->renderField('email'));
                                ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php
                                $this->form->setValue('address',null, $user->data->user_plugin->address);
                                echo ($this->form->renderField('address'));
                                ?>
                                <?php
                                echo ($this->form->renderField('mobile'));
                                ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php echo ($this->form->renderField('gender')); ?>
                                <?php echo ($this->form->renderField('birthday')); ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php
                                $this->form->setValue('company',null, $user->data->user_plugin->company);
                                echo ($this->form->renderField('company'));
                                ?>
                                <?php
                                $this->form->setValue('business',null, $user->data->user_plugin->business);
                                echo ($this->form->renderField('business'));
                                ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php
                                $this->form->setValue('facebook','params', isset($user->data->user_plugin->params) && ($user->data->user_plugin->params)?$user->data->user_plugin->params->get('facebook'):'');
                                echo($this->form->renderField('facebook','params'))
                                ?>
                                <?php
                                $this->form->setValue('instagram','params', isset($user->data->user_plugin->params) && ($user->data->user_plugin->params)?$user->data->user_plugin->params->get('instagram'):'');
                                echo($this->form->renderField('instagram','params'))
                                ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php
                                $this->form->setValue('twitter','params', isset($user->data->user_plugin->params) && ($user->data->user_plugin->params)?$user->data->user_plugin->params->get('twitter'):'');
                                echo($this->form->renderField('twitter','params'))
                                ?>
                                <?php
                                $this->form->setValue('youtube','params', isset($user->data->user_plugin->params) && ($user->data->user_plugin->params)?$user->data->user_plugin->params->get('youtube'):'');
                                echo($this->form->renderField('youtube','params'))
                                ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php
                                $this->form->setValue('printerest','params', isset($user->data->user_plugin->params) && ($user->data->user_plugin->params)?$user->data->user_plugin->params->get('printerest'):'');
                                echo($this->form->renderField('printerest','params'))
                                ?>
                            </div>
                            <div class="wrapper-account-detail">
                                <?php
                                $this->form->setValue('description',null, $user->data->user_plugin->description);
                                echo ($this->form->renderField('description'));
                                ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <?php echo ($this->form->renderField('image')); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div id="change-paswword" class="tab-pane fade">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field = $this->form->getField('user_pass');
                        echo ($field->input);
                        ?>
                    </div>
                </div>
            </div>
            <div id="billing-address" class="tab-pane fade">
                <div class="row">
                    <div class="col-md-12">
                        <div class="wrapper-billing-address">
                            <?php echo ($this->form->renderField('country')); ?>
                            <?php
                            $this->form->setValue('address_bill',null, $user->data->user_plugin->address_bill);
                            echo ($this->form->renderField('address_bill'));
                            ?>
                        </div>
                        <div class="wrapper-billing-address">
                            <?php
                            $this->form->setValue('city',null, $user->data->user_plugin->city);
                            echo ($this->form->renderField('city'));
                            ?>
                            <?php
                            $this->form->setValue('state',null, $user->data->user_plugin->state);
                            echo ($this->form->renderField('state'));
                            ?>
                        </div>
                        <div class="wrapper-billing-address">
                            <?php
                            $this->form->setValue('postcode',null, $user->data->user_plugin->postcode);
                            echo ($this->form->renderField('postcode'));
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if($user->data->user_plugin->group_user_alias == 'vendor') {?>
                <div id="banner-graphic" class="tab-pane fade">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="wrapper-banner-graphic">
                                <?php
                                    $field = $this->form->getField('gallery');
                                    echo ($field->input);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php }?>
        </div>
    </div>
    <div class="wrapper-button">
        <a href="<?php echo (esc_url($this->page_user_account.'?layout=profile-user'))?>" class="btn-cancel">
            <i class="fas fa-undo-alt"></i>
            <?php esc_html_e('Cancel','wpbookingpro');?>
        </a>
        <button class="btn-save btn-save-change" type="button">
            <i class="icon-nb-save"></i>
            <?php esc_html_e('Save','wpbookingpro');?>
        </button>
    </div>
</div>
