<?php
namespace WpBookingProFrontend\app\views\account;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;

class AccountView extends View
{
    public function display($tpl){
        $input = FactoryAlias::getInput();
        $modelUser = Model::getInstance('user');
        $id= $input->getInt('id', 0);
        $this->form = $modelUser->getForm();
        $this->user = $modelUser->getUserInfo();


        $modelOrders = Model::getInstance('orders');
        $this->list_order_by_user = $modelOrders->getListOrderByUserID();
        $this->list_order_by_vendor = $modelOrders->getListOrderByVendorID();
        $this->list_service_wishlist = $modelOrders->getListServiceWishlistByUser();


        $modelCategory = Model::getInstance('category');
        $this->category_item = $modelCategory->getItem($id);
        $modelCategories = Model::getInstance('categories');
        $this->list_category = $modelCategories->getListCategoryByUser();
        $this->form_category = $modelCategory->getForm();

        $modelService = Model::getInstance('service');
        $this->service_item = $modelService->getItem($id);
        $modelServices = Model::getInstance('services');
        $this->list_service = $modelServices->getListServiceByUser();
        $this->form_service = $modelService->getForm();

        $modelEmployee = Model::getInstance('employee');
        $this->employee_item = $modelEmployee->getItem($id);
        $modelEmployees = Model::getInstance('employees');
        $this->list_employee = $modelEmployees->getListEmployeeByUser();
        $this->form_employee = $modelEmployee->getForm();

        $modelReview = Model::getInstance('review');
        $this->form_review = $modelReview->getForm();
        $this->review_item = $modelReview->getItem($id);
        $modelReviews = Model::getInstance('reviews');
        $this->list_review_vendor = $modelReviews->getListReviewVendor();
        $this->list_review_service = $modelReviews->getListReviewService();

        $modelLocation = Model::getInstance('location');
        $this->form_location = $modelLocation->getForm();
        $this->location_item = $modelLocation->getItem($id);
        $modelLocations = Model::getInstance('locations');
        $this->list_location = $modelLocations->getList();

        $modelState = Model::getInstance('state');
        $this->form_state = $modelState->getForm();
        $this->state_item = $modelState->getItem($id);
        $modelStates = Model::getInstance('states');
        $this->list_state = $modelStates->getList();

        $modelCustomer= Model::getInstance('customer');
        $this->form_customer = $modelCustomer->getForm();
        $this->customer_item = $modelCustomer->getItem($id);
        $modelCustomers= Model::getInstance('customers');
        $this->list_customers = $modelCustomers->getList();

        $modelCoupon= Model::getInstance('coupon');
        $this->form_coupon = $modelCoupon->getForm();
        $this->coupon_item = $modelCoupon->getItem($id);
        $modelCoupons= Model::getInstance('coupons');
        $this->list_coupons = $modelCoupons->getListCouponByUser();


        $input = FactoryAlias::getInput();
        $order_id = $input->getInt('order_id',0);
        if($order_id > 0) {
            $modelOrder = Model::getInstance('order');
            $this->order = $modelOrder->getItem($order_id);

        }

        return parent::display($tpl);
    }
}