<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class VendorsModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "vendors";
    /**
     * @var string
     */
    public $table_name = "user";

    public function getListVendor() {
        $input = Factory::getInput();
        $limit = $input->getInt('limit', 1);
        $start = $input->getInt('start', 0);
        $total_result = $input->getInt('total_result', 0);
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('user.*')
            ->from($this->getTableName('user').' AS user')
            ->leftJoin($this->getTableName('groupuser').' AS groupuser ON groupuser.id=user.group_user_id')
            ->where('groupuser.alias='.$query->quote('vendor'))
        ;
        $list_vendor = $db->setQuery($query,$start * $limit, (($total_result - $start * $limit) > $limit)?$limit: ($total_result - $start * $limit))->loadObjectList();
        foreach ($list_vendor as $vendor) {

            $query->clear()
                ->select('*')
                ->from($this->getTableName('service'))
                ->where('user_id='.(int)$vendor->id)
            ;
            $list_service = $db->setQuery($query)->loadObjectList();
            $vendor->list_service = $list_service;

        }
        return  $list_vendor;
    }

    public function getTotalVendorNoPagination() {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('user.*')
            ->from($this->getTableName('user').' AS user')
            ->leftJoin($this->getTableName('groupuser').' AS groupuser ON groupuser.id=user.group_user_id')
            ->where('groupuser.alias='.$query->quote('vendor'))
        ;
        $list_vendor = $db->setQuery($query)->loadObjectList();
        return count($list_vendor);
    }

    public function renderVendorHtmlAjax() {
        $list_vendor = $this->getListVendor();
        $input = Factory::getInput();
        $page_vendor_detail = $input->getString('page_vendor_detail','');
        ob_start();
        foreach ($list_vendor as $vendor) {
            ?>
            <div class="col-sm-6 col-md-4 col-lg-3">
                <div class="block-vendor-item" >
                    <div class="content-top">
                        <div class="img-block">
                            <div>
                                <img src="<?php echo( esc_url(isset($vendor->image)?$vendor->image:''))?>" alt="vendor-image">
                            </div>
                        </div>
                    </div>
                    <div class="content-bottom">
                        <h3><?php echo (esc_html(isset($vendor->first_name) || isset($vendor->last_name)?Utility::get_full_name($vendor->first_name, $vendor->last_name):''))?></h3>
                        <div class="address infor-item">
                            <i class="icon-nb-pin"></i>
                            <span><?php echo (esc_html(isset($vendor->address)?$vendor->address:''))?></span>
                        </div>
                        <div class="email infor-item">
                            <i class="icon-nb-email"></i>
                            <span><?php echo (esc_html(isset($vendor->email)?$vendor->email:''))?></span>
                        </div>
                        <div class="number-products">
                            <span><?php echo (esc_html(isset($vendor->list_service)?count($vendor->list_service):0))?></span>
                            <span><?php esc_html_e('products','wpbookingpro');?></span>
                        </div>
                        <a href="<?php echo (esc_url($page_vendor_detail.'?user_id='.$vendor->id))?>" class="view-profile"><?php esc_html_e('View shop','wpbookingpro');?></a>
                    </div>
                </div>
            </div>
            <?php
        }
        $content = ob_get_clean();
        return $content;
    }

}
