<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Router\Route;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

class VendorModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "vendor";
    /**
     * @var string
     */
    public $table_name = "user";

    public function getInfoVendor($id='') {
        $input = Factory::getInput();
        $price_search = $input->getString('price_search', '');
        $keyword = $input->getString('keyword', '');
        $sort = $input->getString('sort','service.ordering');
        $direction = $input->getString('direction','');
        if($price_search!== ''){
            $price_search=(array)json_decode($price_search);
        }
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('user.*')
            ->from($this->getTableName('user').' AS user')
            ->leftJoin($this->getTableName('groupuser').' AS groupuser ON groupuser.id=user.group_user_id')
            ->where('groupuser.alias='.$query->quote('vendor'))
            ->where('user.id='.(int)$id)
        ;
        $vendor = $db->setQuery($query)->loadObject();
        if(!empty($vendor)) {
            $query->clear()
                ->select('*')
                ->from($this->getTableName('category'))
                ->where('user_id='.(int)$vendor->id)
            ;
            $list_category = $db->setQuery($query)->loadObjectList();
            foreach ($list_category as &$category) {
                $query->clear()
                    ->select('COUNT(*)')
                    ->from($this->getTableName('service'))
                    ->where('category_id='.(int)$category->id)
                ;
                $category->number_service = $db->setQuery($query)->loadResult();
            }
            $vendor->list_category = $list_category;

            $query->clear()
                ->select('service.*')
                ->from($this->getTableName('service').' AS service')
                ->where('service.user_id='.(int)$vendor->id)
            ;
            if($price_search !== '' && is_array($price_search) && !empty($price_search)) {
                $query->where('service.price >='.(float)min($price_search))
                    ->where('service.price <='.(float)max($price_search));
            }
            if(trim($keyword) != '') {
                $query->where('service.name LIKE '.$query->quote("%$keyword%"))
                ;
            }
            $query->order("$sort $direction");
            $list_service = $db->setQuery($query)->loadObjectList();

            foreach ($list_service as $key => &$item) {
                $query = $this->db->getQuery(true);
                $query->clear()
                    ->select('category.*')
                    ->from($this->getTableName('category') . ' AS category')
                    ->where('category.id=' . (int)$item->category_id);
                $item->category = $this->db->setQuery($query)->loadObject();
                $query->clear()
                    ->select('employee.*')
                    ->from($this->getTableName('employee') . ' AS employee')
                    ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                    ->where('service_employee.service_id=' . (int)$item->id);
                $list_employee = $this->db->setQuery($query)->loadObjectList();
                $list_employee_id = [];
                foreach ($list_employee as $employee) {
                    $employee->full_name = $employee->first_name. ' ' .$employee->last_name;
                    array_push($list_employee_id, $employee->id);
                }
                $item->list_employee = $list_employee;
                $item->list_employee_id = $list_employee_id;
                $query->clear()
                    ->select('location.*')
                    ->from($this->getTableName('location') . ' AS location')
                    ->where('location.id=' . (int)$item->location_id)
                ;
                $location = $this->db->setQuery($query)->loadObjectList();
                $item->location = reset($location);

                $query->clear()
                    ->select('review.*')
                    ->from($this->getTableName('review').' AS review')
                    ->leftJoin($this->getTableName('service_review').' AS service_review ON service_review.review_id=review.id')
                    ->where('service_review.service_id='.(int)$item->id)
                    ->where('review.published=1')
                ;
                $list_review = $this->_db->setQuery($query)->loadObjectList();

                $user_id = isset($_SESSION['user_id'])?$_SESSION['user_id']:'';
                $query->clear()
                    ->select('wishlist.id')
                    ->from($this->getTableName('wishlist').' AS wishlist')
                    ->where('wishlist.service_id='.(int)$item->id)
                    ->where('wishlist.user_id='.(int)$user_id)
                ;
                $wishlist = $this->_db->setQuery($query)->loadResult();
                $item->wishlist = $wishlist;


                $arr_rating_avg = array();
                foreach ($list_review as $review) {
                    $rating_ambience = isset($review->rating_ambience)?$review->rating_ambience:0;
                    $rating_cleanliness = isset($review->rating_cleanliness)?$review->rating_cleanliness:0;
                    $rating_staff = isset($review->rating_staff)?$review->rating_staff:0;
                    $rating_value = isset($review->rating_value)?$review->rating_value:0;
                    $review->avg_rating = ($rating_ambience + $rating_cleanliness + $rating_staff + $rating_value) / 4;
                    array_push($arr_rating_avg,$review->avg_rating);
                }
                $item->list_review = $list_review;
                if(!empty($arr_rating_avg)) {
                    $item->rating_avg = array_sum($arr_rating_avg) / count($arr_rating_avg);
                }else {
                    $item->rating_avg = 0;
                }
                if(!empty($rating)) {
                    if($item->rating_avg < min($rating) || $item->rating_avg > max($rating)) {
                        unset($list_service[$key]);
                    }
                }



                $register = new Registry();
                $register->loadString($item->params);
                $item->params = $register;
            }

            $vendor->list_service = $list_service;

            $limit = $input->getInt('limit', 1);
            $start = $input->getInt('start', 0);
            $total_result = $input->getInt('total_result', 0);
            $query->clear()
                ->select('review.*')
                ->from($this->getTableName('review'). ' AS review')
                ->leftJoin($this->getTableName('vendor_review').' AS vendor_review ON vendor_review.review_id= review.id')
                ->where('vendor_review.user_id='.(int)$vendor->id)
            ;
            $list_review = $db->setQuery($query, $start * $limit, (($total_result - $start * $limit) > $limit)?$limit: ($total_result - $start * $limit))->loadObjectList();
            $vendor->list_review = $list_review;

            $query->clear()
                ->select('*')
                ->from($this->getTableName('gallery'))
                ->where('type='.$query->quote('vendor'))
                ->where('object_id='.(int)$vendor->id)
            ;
            $gallery = $db->setQuery($query)->loadObjectList();
            $vendor->gallery = $gallery;

            $register = new Registry();
            $register->loadString($vendor->params);
            $vendor->params = $register;

            return  $vendor;
        }
        return array();

    }

    public function renderServiceHtmlAjax() {
        $result = array();
        if(!function_exists('wp_get_current_user')) {
            include(ABSPATH . "wp-includes/pluggable.php");
        }
        $input = Factory::getInput();
        $user_id = $input->getInt('user_id', 0);
        $page_service_detail = $input->getString('page_service_detail', 0);
        $vendor = $this->getInfoVendor($user_id);
        $list_service = $vendor->list_service;
        $user_id_login = isset($_SESSION['user_id'])?$_SESSION['user_id']:'';
        $check_user_demo = FrontendHelper::checkUserDemo();
        $uploads = wp_upload_dir();
        ob_start();
        if(is_array($list_service) && !empty($list_service)) {
            foreach ($list_service as $service) {
                $rating_avg = $service->rating_avg;
                $list_star_sum = HtmlFrontend::get_rating_star($rating_avg);
                $list_review = isset($service->list_review)?$service->list_review:array();
                $near_me = 0;
                $unit_for_search= '';
                $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $service->image);
                ?>
                <div class="block-service-item" data-service_id="<?php echo (esc_attr(isset($service->id)?$service->id:''))?>">
                    <div class="content-top">
                        <a href="<?php echo (esc_url(Route::_($page_service_detail.'?service_id='.$service->id)))?>">
                            <div class="block-img">
                                <div>
                                    <?php if($check_user_demo['is_demo']) {?>
                                        <?php if($check_image_size) {?>
                                            <img src="<?php echo (esc_url(isset($service->image)?$uploads['baseurl'].'/'.$service->image:Factory::getRootUrlPlugin().'frontend/app/assets/images/no-image.jpg')) ?>" alt="service-image">
                                        <?php } else {?>
                                            <img src="<?php echo (esc_url(isset($service->image)?Factory::getRootUrlPlugin().$service->image:Factory::getRootUrlPlugin().'frontend/app/assets/images/no-image.jpg')) ?>" alt="service-image">
                                        <?php } ?>

                                    <?php } else {?>
                                        <img src="<?php echo (esc_url(isset($service->image)?Factory::getRootUrlPlugin().$service->image:Factory::getRootUrlPlugin().'frontend/app/assets/images/no-image.jpg')) ?>" alt="service-image">
                                    <?php } ?>
                                </div>
                            </div>
                        </a>
                        <div class="block-feature">
                            <div class="label-feature <?php echo (esc_attr(isset($service->is_feature) && $service->is_feature==1 ? 'visible':''));?>">
                                <span><?php esc_attr_e('Featured','wpbookingpro');?></span>
                            </div>
                            <?php if($user_id_login !='') {?>
                                <i class="fas fa-heart <?php echo (esc_attr(isset($service->wishlist)? 'active':'')) ?>"></i>
                            <?php }?>
                        </div>
                    </div>
                    <div class="content-bottom">
                        <p class="place-service">
                            <i class="icon-nb-pin"></i>
                            <?php echo (isset($service->location->address)?$service->location->address:'')?>
                        </p>
                        <a href="<?php echo (esc_url(Route::_($page_service_detail.'?service_id='.$service->id)))?>">
                            <h4 class="name-service">
                                <?php echo (esc_html(isset($service->name)?$service->name:''))?>
                            </h4>
                        </a>
                        <div class="block-rating">
                            <ul class="list-rating-star">
                                <?php if($rating_avg > 0) {?>
                                    <?php for ($i=0; $i < $list_star_sum[0]; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$list_star_sum[1]; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$list_star_sum[2]; $i++) {?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    <?php }?>
                                <?php } else {?>
                                    <?php for ($i=0; $i < 5;$i++) {?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    <?php }?>
                                <?php }?>
                            </ul>
                            <div class="rating-review">
                                <span><?php echo (esc_html(count($list_review)))?> <?php esc_attr_e('Reviews','wpbookingpro');?></span>
                            </div>
                        </div>
                        <div class="block-trip-price">
                            <div class="time-trip">
                                <i class="icon-nb-clock"></i>
                                <span><?php echo (esc_html(isset($service->duration)?$service->duration:0))?> <?php esc_attr_e('hours','wpbookingpro');?></span>
                            </div>
                            <div class="price-service">
                                <span><i class="fas fa-bolt"></i><span><?php esc_attr_e('From','wpbookingpro');?></span></span>
                                <span class="price"><?php echo (esc_html(HtmlFrontend::render_price(isset($service->price)?$service->price:0)))?></span>
                            </div>
                        </div>
                        <?php if($near_me == 1) {?>
                            <div class="distance-between-your-location">
                                <i class="fas fa-map-pin"></i>
                                <span>
                        <?php echo (esc_html(isset($service->distance)?$service->distance:0))?>
                        <?php
                        if($unit_for_search == 'Km') {
                            echo (esc_html('Km'));
                        } elseif ($unit_for_search='Mi') {
                            echo (esc_html('Mile'));
                        }
                        ?>
                    </span>
                            </div>
                        <?php }?>
                    </div>
                </div>
                <?php
            }
        } else {
            ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="alert-block">
                        <span><?php esc_attr_e('Could not found any services','wpbookingpro')?></span>
                    </div>
                </div>
            </div>
            <?php
        }

        $content = ob_get_clean();
        $result['total_service'] = count($list_service);
        $result['html'] = $content;
        return $result;
    }

    public function renderReviewHtmlAjax() {
        $input = Factory::getInput();
        $user_id = $input->getInt('user_id', 0);
        $vendor = $this->getInfoVendor($user_id);
        $list_review = $vendor->list_review;
        ob_start();
        foreach ($list_review as $review_item) {
            ?>
            <div class="block-review-item">
                <div class="img-block">
                    <div>
                        <img src="<?php echo (Factory::getRootUrlPlugin())?>frontend/app/assets/images/avatar-reviewer.jpg" alt="avatar-reviewer">
                    </div>
                </div>
                <div class="block-content">
                    <h5><?php echo (esc_html(isset($review_item->name)?$review_item->name:''))?></h5>
                    <ul class="list-rating-star">
                        <?php $list_star_sum_review = HtmlFrontend::get_rating_star($review_item->rating_vendor);?>
                        <?php for ($i=0; $i < $list_star_sum_review[0]; $i++) {?>
                            <li class="item-star"><i class="fas fa-star"></i></li>
                        <?php }?>
                        <?php for ($i=0; $i < $list_star_sum_review[1]; $i++) {?>
                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                        <?php }?>
                        <?php for ($i=0; $i < $list_star_sum_review[2]; $i++) {?>
                            <li class="item-star"><i class="far fa-star"></i></li>
                        <?php }?>
                    </ul>
                    <p><?php echo (esc_html(isset($review_item->comments)?$review_item->comments:''))?></p>
                </div>
                <div class="block-time-review">
                    <h6><?php esc_html_e('Visited', 'wpbookingpro');?> <?php echo (esc_html(date('F d, Y',strtotime($review_item->created_date))))?></h6>
                </div>
            </div>
            <?php
        }
        $content = ob_get_clean();
        return $content;
    }

}
