<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;

class ReviewModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "review";
    /**
     * @var string
     */
    public $table_name = "review";


    public function save_review($data = array())
    {
        $created_date = Factory::getDate();
        $data['created_date'] = $created_date->toSql();
        $data['published'] = 1;
        $review = $this->save($data);
        $service_id = isset($data['service_id'])?$data['service_id']:0;
        $user_id = isset($data['user_id'])?$data['user_id']:0;
        $query = $this->_db->getQuery(true);
        if($service_id > 0) {
            $query->clear()
                ->insert($this->getTableName('service_review'))
                ->set('review_id='.(int)($review->id))
                ->set('service_id='.(int)$service_id)
            ;
            $this->_db->setQuery($query)->execute();
        } else {
            $query->clear()
                ->insert($this->getTableName('vendor_review'))
                ->set('review_id='.(int)($review->id))
                ->set('user_id='.(int)$user_id)
            ;
            $this->_db->setQuery($query)->execute();
        }

    }



}
