<?php
namespace WpBookingProFrontend\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\payments\WBPayment;
use WpBookingPro\Registry\Registry;

class PaymentModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "payment";
    /**
     * @var string
     */
    public $table_name = "payment";
    public function getItem($open_source_payment_id = '')
    {
        $query = $this->_db->getQuery(true);
        $query->select('payment.*')
            ->from($this->getTableName('payment'). ' AS payment')
            ->where('payment.open_source_payment_id='.$query->quote($open_source_payment_id))
            ;
        $item = $this->_db->setQuery($query)->loadObject();
        return $item;
    }

    public function getPaymentPlugin($open_source_payment_id)
    {
        $payment = $this->getItem($open_source_payment_id);
        $paymentPlugin = WBPayment::getInstance($payment->type, $payment);
        return $paymentPlugin;
    }
}
