<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);

$week = array('Monday','Tuesday' ,'Wednesday' ,'Thursday' ,'Friday','Saturday','Sunday');

if(isset($value) && trim($value) != '') {
    $arr_value= json_decode($value);
} else {
    $arr_value=array();
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> element-field-selectday">
        <?php foreach ($week as $dayName) {?>
            <label class="name-day-of-week">
                <input type='checkbox' class="day-of-week" value="<?php echo (esc_attr($dayName));?>" <?php echo (esc_attr(in_array($dayName,$arr_value)? 'checked':'')); ?>/>
                <?php echo (esc_html($dayName));?>
            </label>
        <?php }?>
        <input type="hidden" name="<?php echo (esc_attr($name));?>">
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlFrontend::load_jquery_library('icheck');
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/selectday/selectday.less');
$doc->addScriptApplySelector('.element-field-selectday','field_selectday',array(
        'input_name'=>$name,
        'value'=>$arr_value
),'frontend/app/layouts/WooBooking/form/field/selectday/selectday.jquery.js');
