<?php

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlFrontend as WpBookingProHtmlFrontendAlias;
use WpBookingPro\Language\Text;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
WpBookingProHtmlFrontendAlias::load_jquery_library('moment');
WpBookingProHtmlFrontendAlias::load_jquery_library('daterangepicker');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-rating-star-vendor">
        <div class='rating-stars'>
            <h5><?php esc_html_e('Rating','wpbookingpro');?></h5>
            <ul id='stars'>
                <li class='star' data-value='1'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='2'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='3'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='4'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='5'>
                    <i class="far fa-star"></i>
                </li>
            </ul>
            <input type="hidden" name="<?php echo (esc_attr($name));?>">
        </div>

    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/ratingstarvendor/ratingstarvendor.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-rating-star-vendor','field_ratingstarvendor',array(
        "field_name"=>$name
),'frontend/app/layouts/WooBooking/form/field/ratingstarvendor/ratingstarvendor.js');