<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> element-field-opentime">
        <input type="text" id="open-time" class="form-control open-time" value="<?php echo (esc_html($value));?>" />
        <input type="hidden" name="<?php echo (esc_attr($name));?>" />
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlFrontend::load_jquery_library('moment');
WpBookingProHtmlFrontend::load_jquery_library('daterangepicker');
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/opentime/opentime.less');
$doc->addScriptApplySelector('.element-field-opentime','field_opentime',array(
    'input_name'=>$name,
    'value'=>$value
),'frontend/app/layouts/WooBooking/form/field/opentime/opentime.jquery.js');
