<?php

use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlFrontend as WpBookingProHtmlFrontendAlias;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


WpBookingProHtmlFrontendAlias::load_jquery_library('select2');

$doc = Factory::getDocument();
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);

$uri = Factory::getUri();
$layout = $uri->getVar('layout','');
$id = $uri->getVar('id','');
if(is_user_logged_in()) {
    if($layout == "account-setting") {
        $modelUser = Model::getInstance('user');
        $user = $modelUser->getUserInfo();
        $value = isset($user->data->user_plugin->gender)?$user->data->user_plugin->gender:'';
    } elseif($layout=="my-customer" && trim($id) != '' && $id > 0) {
        $modelCustomer = Model::getInstance('customer');
        $customer = $modelCustomer->getItem($id);
        $value = isset($customer->gender)?$customer->gender:'';
    }
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-gender">
        <select class="list-gender" name="<?php echo (esc_attr($name)); ?>">
            <option value=""><?php esc_html_e('Select Gender','wpbookingpro') ?></option>
            <option <?php echo($value == 'male' ? ' selected ' : '') ?> value="male"><?php esc_html_e('Male','wpbookingpro') ?></option>
            <option <?php echo($value == 'female' ? ' selected ' : '') ?> value="female"><?php esc_html_e('Female','wpbookingpro') ?></option>
        </select>
    </div>
<?php
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/gender/gender.less');
$doc->addScriptApplySelector('.field-gender', 'field_gender', array(
), 'frontend/app/layouts/WooBooking/form/field/gender/jquery.gender.js');
