<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlFrontend as WpBookingProHtmlFrontendAlias;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlFrontendAlias::load_jquery_library('auto_numeric');

$doc = Factory::getDocument();

$id_by_name = "element_field_". $name;
?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="field-duration">
        <div class="wrapper-duration">
            <input type="text" value="<?php  esc_attr_e($value) ?>" class="form-control duration">
            <input type="hidden" <?php echo ($required?' required="required" ':'') ?>
                   name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>">
        </div>
    </div>
<?php
$doc->addLessStylesheet('frontend/app/layouts/WooBooking/form/field/duration/duration.less');
$doc->addScriptApplySelector('#'.$id_by_name,'field_duration',array(
    "input_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/duration/jquery.duration.js');
