<?php
use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\FrontendHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_" . $name;
$data = $field->getForm()->getData();

$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
$check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $value);

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-cover">
        <div class="wrapper-field-cover">
            <div class="img-block">
                <div>
                    <?php if($check_user_demo['is_demo']) {?>
                        <?php if($check_image_size) {?>
                            <img class="img-avatar" src="<?php echo (esc_url($value ? $uploads['baseurl'].'/'.$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                        <?php } else {?>
                            <img class="img-avatar" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin().$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                        <?php } ?>

                    <?php } else {?>
                        <img class="img-avatar" src="<?php echo (esc_url($value ? Factory::getRootUrlPlugin() .$value : Factory::getRootUrlPlugin().$default)) ?>" alt="avatar" />
                    <?php } ?>
                </div>
            </div>
            <button type="button" class="btn-upload-image">
                <i class="fas fa-cloud-upload-alt"></i>
                <?php esc_html_e('Upload Image','wpbookingpro');?>
            </button>
            <input type="file" class="upload"  name="<?php echo (esc_attr($name)); ?>" style="display: none"/>
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('frontend/app/layouts/WooBooking/form/field/cover/cover.less');
$doc->addScriptApplySelector("#$id_by_name",'field_cover',array(
),'frontend/app/layouts/WooBooking/form/field/cover/cover.jquery.js');