<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlFrontend as WpBookingProHtmlFrontendAlias;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

WpBookingProHtmlFrontendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelcountries = Model::getInstance('countries');
$list = $modelcountries->getList();
$list_time = [];
$list_country_id = [];

if(is_user_logged_in()) {
    $modelUser = Model::getInstance('user');
    $user = $modelUser->getUserInfo();
    $value = $user->data->user_plugin->country;
}
if (!is_array($value)) {
	$list_country_code[] = $value;
} else {
	$list_country_code = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-countries">
        <select name="<?php echo (esc_attr($name)); ?>" required="<?php echo (esc_attr($required)) ?>" <?php echo (esc_attr($multiple ? ' multiple ' : null)); ?>class="list-country">
            <option value=""><?php esc_html_e('Select country','wpbookingpro') ?></option>
			<?php foreach ($list as $item) { ?>
                <option <?php echo (esc_attr(in_array($item->code, $list_country_code) ? ' selected ' : null)) ?>value="<?php echo (esc_attr($item->code)); ?>"><?php echo (esc_html($item->countryname)); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/countries/countries.less');
$doc->addScriptApplySelector('.field-countries','field_countries',array(
),'frontend/app/layouts/WooBooking/form/field/countries/countries.jquery.js');