<?php

use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingPro\Html\WpBookingProHtmlFrontend as WpBookingProHtmlFrontendAlias;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);


WpBookingProHtmlFrontendAlias::load_jquery_library('moment');
WpBookingProHtmlFrontendAlias::load_jquery_library('daterangepicker');

$doc = Factory::getDocument();
$id_by_name = "element_field_". $name;

if(is_user_logged_in()) {
    $modelUser = Model::getInstance('user');
    $user = $modelUser->getUserInfo();
    $value = $user->data->user_plugin->birthday;
}

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-birthday">
        <div class="row">
            <div class="col-md-12">
                <div class="input-group">
                    <input type="text" class="birthday" id="birthday" value="<?php echo (esc_attr($value))?>">
                    <i class="far fa-calendar-alt"></i>
                    <input type="hidden" name="<?php echo (esc_attr($name));?>" value="<?php echo (esc_attr($value))?>">
                </div>
            </div>
        </div>
    </div>
<?php
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/birthday/birthday.less');
$doc->addScriptApplySelector('.field-birthday', 'field_birthday', array(
    "input_name" => $name,
), 'frontend/app/layouts/WooBooking/form/field/birthday/jquery.birthday.js');
