<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class VendorController extends ControllerFrontend
{
    public function get_list_services_ajax(){
        $input = Factory::getInput();
        $data =  $input->getData();
        $dataObj = isset($data['dataObj'])?$data['dataObj']:array();

        foreach ($dataObj as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            } else if(!is_array($value)) {
                $input->set($key, $value);
            }
        }
        $modelVendor = Model::getInstance('vendor');
        $result = $modelVendor->renderServiceHtmlAjax();
        return $result;
    }

    public function get_list_review_ajax() {
        $input = Factory::getInput();
        $data =  $input->getData();
        $dataObj = isset($data['dataObj'])?$data['dataObj']:array();

        foreach ($dataObj as $key => $value) {
            if(is_array($value) && count($value) == 1) {
                $input->set($key, $value[0]);
            } else if(is_array($value) && count($value) > 1) {
                $input->set($key, $value);
            } else if(!is_array($value)) {
                $input->set($key, $value);
            }
        }

        $modelVendor = Model::getInstance('vendor');
        $result = $modelVendor->renderReviewHtmlAjax();
        return $result;
    }

}
