<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class OrderController extends ControllerFrontend
{
    public function update_order_after_payment_success() {
        $input = Factory::getInput();
        $data = $input->getData();
        $order_id = isset($data['order_id'])?$data['order_id']:0;
        $modelOrder = Model::getInstance('order');
        $order = $modelOrder->getItem($order_id);
        $modelOrder->updateOrderAfterPaymentSuccess($data);
        Utility::redirect(Factory::getRootUrl().'/wpbookingpro/?view=payment-return&order_id='.$order->id.'&payment_schedule='.$order->payment_schedule.'&day_ordinal='.$order->day_ordinal);
    }
    public function update_order_after_payment_cancel() {
        $input = Factory::getInput();
        $data = $input->getData();
        $order_id = isset($data['order_id'])?$data['order_id']:0;
        $modelOrder = Model::getInstance('order');
        $order = $modelOrder->getItem($order_id);
        $modelOrder->updateOrderAfterPaymentCancel($data);
        Utility::redirect(Factory::getRootUrl().'/wpbookingpro/?view=payment-cancel&order_id='.$order->id.'&payment_schedule='.$order->payment_schedule.'&day_ordinal='.$order->day_ordinal);
    }

    public function ajax_change_order_status()
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $modelOrder = Model::getInstance('order');
        $order = $modelOrder->change_order_status($data);
        return $order;
    }

}
