<?php

namespace WpBookingProFrontend\app\controllers;

use WpBookingPro\Factory;
use WpBookingPro\Filesystem\Support\StringController;
use WpBookingPro\Mvc\Controller\ControllerFrontend;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\EmailHelper;

defined('_WPBOOKINGPRO_EXEC') or die;

/**
 * Class BlockController
 */
class CouponController extends ControllerFrontend
{
    public function check_coupon(){
        $input = Factory::getInput();
        $data =  $input->getData();
        $modelCoupon = Model::getInstance('coupon');
        $result = $modelCoupon->checkCouponCode($data);
        return $result;
    }
    public function save($data = array())
    {
        $input = Factory::getInput();
        $data = $input->getData();
        $modelCoupon = Model::getInstance('coupon');
        $coupon = $modelCoupon->save($data);
        $link_redirect = isset($data['link_redirect'])?$data['link_redirect']:'';
        Utility::redirect($link_redirect);
        return parent::save($data); // TODO: Change the autogenerated stub
    }

    public function delete_coupon_ajax()
    {
        $input = Factory::getInput();
        $coupon_id = $input->getInt('coupon_id',0);
        $link_my_coupon = $input->getString('link_my_coupon','');
        $modelCoupon = Model::getInstance('coupon');
        $modelCoupon->delete($coupon_id);
        $db= Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->delete(Utility::getTableName('service_coupon'))
            ->where('coupon_id='.(int)$coupon_id)
        ;
        $db->setQuery($query)->execute();
        Utility::redirect($link_my_coupon);
    }

}
