"use strict";
(function ($) {
    $.view_user_account = function (element, options) {
        let defaults = {
            old_pass_ok:false,
            new_pass_ok:false,
            confirm_new_pass_ok:false,
            link_my_category:"",
        }
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('table#list-order-user').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
            });
            $element.find('table#list-order-customer').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
            });

            $element.find('table#wish-list').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
            });
            $element.find('table#list-location').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find(".btn-delete-location").on('click', function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let location_id = $tr.data('location_id');
                        $form.find('input[name="location_id"]').val(location_id);
                        $form.find('input[name="task"]').val("location.delete");
                        $.confirm({
                            title: 'Message!',
                            content: 'Do you want delete item!',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                }
                            }
                        });

                    });
                }
            });
            $element.find('table#list-state').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find(".btn-delete-state").on('click', function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let state_id = $tr.data('state_id');
                        $form.find('input[name="state_id"]').val(state_id);
                        $form.find('input[name="task"]').val("state.delete");
                        $.confirm({
                            title: 'Message!',
                            content: 'Do you want delete item!',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                }
                            }
                        });

                    });
                }
            });
            $element.find('table#list-customer').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find(".btn-delete-customer").on('click', function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let customer_id = $tr.data('customer_id');
                        $form.find('input[name="customer_id"]').val(customer_id);
                        $form.find('input[name="task"]').val("customer.delete");
                        $.confirm({
                            title: 'Message!',
                            content: 'Do you want delete item!',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                }
                            }
                        });

                    });
                }
            });
            $element.find('table#list-review-service').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find(".btn-delete-review-service").on('click', function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let review_id = $tr.data('review_id');
                        $form.find('input[name="review_id"]').val(review_id);
                        $form.find('input[name="task"]').val("review.delete");
                        $.confirm({
                            title: 'Message!',
                            content: 'Do you want delete item!',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                }
                            }
                        });

                    });
                }
            });
            $element.find('table#list-review-vendor').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find(".btn-delete-review-vendor").on('click', function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let review_id = $tr.data('review_id');
                        $form.find('input[name="review_id"]').val(review_id);
                        $form.find('input[name="task"]').val("review.delete");
                        $.confirm({
                            title: 'Message!',
                            content: 'Do you want delete item!',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                }
                            }
                        });

                    });
                }
            });

            $element.find('table#list-category').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find('button.btn-delete-category').on('click',function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let category_id = $tr.data("category_id");
                        $form.find('input[name="category_id"]').val(category_id);
                        $form.find('input[name="task"]').val("category.delete_category_ajax");
                        $.alert({
                            title:'Message',
                            content: 'Are you sure delete category?',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                },
                            }
                        });


                    });
                }
            });

            $element.find('table#list-service').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find('button.btn-delete-service').on('click', function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let service_id = $tr.data("service_id");
                        $form.find('input[name="service_id"]').val(service_id);
                        $form.find('input[name="task"]').val("service.delete_service_ajax");
                        $.alert({
                            title: 'Message',
                            content: 'Are you sure delete service?',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                },
                            }
                        });
                    })
                }
            });
            $element.find('table#list-employee').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find('button.btn-delete-employee').on('click',function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let service_id = $tr.data("employee_id");
                        $form.find('input[name="employee_id"]').val(service_id);
                        $form.find('input[name="task"]').val("employee.delete_employee_ajax");
                        $.alert({
                            title:'Message',
                            content: 'Are you sure delete employee?',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                },
                            }
                        });


                    });
                }
            });
            $element.find('table#list-coupon').DataTable({
                language: {
                    paginate: {
                        previous: "<i class=\"icon-nb-arrow\"></i>",
                        next: "<i class=\"icon-nb-arrow\"></i>"
                    }
                },
                responsive: true,
                "scrollX": true,
                drawCallback: function () {
                    $element.find('button.btn-delete-coupon').on('click',function () {
                        let $form = $(this).closest('form[name="form-account"]');
                        let $tr = $(this).closest('tr');
                        let service_id = $tr.data("coupon_id");
                        $form.find('input[name="coupon_id"]').val(service_id);
                        $form.find('input[name="task"]').val("coupon.delete_coupon_ajax");
                        $.alert({
                            title:'Message',
                            content: 'Are you sure delete item?',
                            buttons: {
                                confirm: function () {
                                    $form.submit();
                                },
                                cancel: function () {
                                },
                            }
                        });


                    });
                }
            });

            $element.find('button.btn-signout').on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val('user.logout_account');
                $form.submit();
            });

            $element.find('.btn-save-change').on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val('user.edit_user_account');
                $form.submit();
            });

            var checkOldUserPass = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value[0];
                });
                $.ajax({
                    url: wpbookingpro_root_url+wpbookingpro_api_task,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        dataObj: dataObj,
                        task: "user.check_old_user_pass",
                    },
                    beforeSend: function() {
                        $('body').loadingModal();
                    },
                    success: function(res) {
                        res = JSON.parse(res)
                        let data = res.data;
                        plugin.settings.old_pass_ok = data;
                        if(data) {
                            $element.find('.old-pass-input i').show();
                            $element.find('.old-pass-input .error-old-pass').hide();

                        } else {
                            $element.find('.old-pass-input i').hide();
                            $element.find('.old-pass-input .error-old-pass').show();
                        }
                    },
                    error: function(xhr) { // if error occured

                    },
                    complete: function() {
                        $('body').loadingModal('destroy');

                    },
                })
            },3000);
            $element.find('input[name="old_pass"]').on('keyup', checkOldUserPass)

            var checkNewPass = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value[0];
                });
                if(dataObj.new_pass !== dataObj.old_pass) {
                    if(/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/.test(dataObj.new_pass)) {
                        $element.find('.new-pass-input i').show();
                        $element.find('.new-pass-input .error-new-pass').hide();
                        $element.find('.new-pass-input .error').hide();
                        plugin.settings.new_pass_ok = true;
                    } else {
                        $element.find('.new-pass-input i').hide();
                        $element.find('.new-pass-input .error-new-pass').hide();
                        $element.find('.new-pass-input .error').show();
                        plugin.settings.new_pass_ok = false;
                    }

                } else {
                    $element.find('.new-pass-input i').hide();
                    $element.find('.new-pass-input .error-new-pass').show();
                    $element.find('.new-pass-input .error').hide();
                    plugin.settings.new_pass_ok = false;
                }

            }, 500);

            $element.find('input[name="new_pass"]').on('keyup', checkNewPass);

            var checkConfirmNewPass = plugin.debounce(function () {
                var output = plugin.convert_data_form();
                let dataObj = {};
                $(output).each(function(i, field){
                    dataObj[field.name] = field.value[0];
                });
                if(dataObj.new_pass !== dataObj.confirm_new_pass) {
                    $element.find('.renew-pass-input i').hide();
                    $element.find('.renew-pass-input .error-renew-pass').show();
                    plugin.settings.confirm_new_pass_ok = false;
                } else {
                    $element.find('.renew-pass-input i').show();
                    $element.find('.renew-pass-input .error-renew-pass').hide();
                    plugin.settings.confirm_new_pass_ok = true;
                }

                if(plugin.settings.old_pass_ok === true && plugin.settings.new_pass_ok === true && plugin.settings.confirm_new_pass_ok === true) {
                    $element.find('input[name="user_pass"]').val(dataObj.confirm_new_pass)
                } else {
                    $element.find('input[name="user_pass"]').val('')
                }

            }, 500);

            $element.find('input[name="confirm_new_pass"]').on('keyup', checkConfirmNewPass);

            $element.find(".btn-save-state").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("state.save");
                $form.submit();
            })
            $element.find(".btn-save-location").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("location.save");
                $form.submit();
            });
            $element.find(".btn-save-customer").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("customer.save");
                $form.submit();
            });
            $element.find(".btn-save-review").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("review.save");
                $form.submit();
            });
            $element.find(".btn-save-service").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("service.save");
                $form.submit();
            });
            $element.find(".btn-save-employee").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("employee.save");
                $form.submit();
            })
            $element.find(".btn-save-category").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("category.save");
                $form.submit();
            })
            $element.find(".btn-save-coupon").on('click', function () {
                let $form = $(this).closest('form[name="form-account"]');
                $form.find('input[name="task"]').val("coupon.save");
                $form.submit();
            });
            $element.find('input[name="amount"]').on('change', function () {
                if($(this).val() > 0) {
                    let $input_percent = $element.find('input[name="percent"]');
                    let $wrapper_duration1 = $input_percent.parent();
                    $element.find('input[name="percent"]').val(0);
                    $wrapper_duration1.find('input.duration').val(0)
                }
            })
            $element.find('input[name="percent"]').on('change', function () {
                if($(this).val() > 0) {
                    let $input_percent = $element.find('input[name="amount"]');
                    let $wrapper_duration1 = $input_percent.parent();
                    $element.find('input[name="amount"]').val(0);
                    $wrapper_duration1.find('input.duration').val(0)
                }
            });

            $element.find('select[name="open_source_order_status_id"]').select2();
            $element.find('select[name="open_source_order_status_id"]').on('change', function () {
                let $tr = $(this).closest('.change-order-status');
                let order_id = $tr.data('order_id');
                let open_source_order_status_id = $(this).val();
                plugin.change_status_order(order_id, open_source_order_status_id);
            });


        };
        plugin.change_status_order = function (order_id, open_source_order_status_id) {
            let data = {
                order_id: order_id,
                open_source_order_status_id: open_source_order_status_id,
                task: "order.ajax_change_order_status"
            };
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wpbookingpro_root_url + wpbookingpro_api_task,
                data: data,
                beforeSend: function () {
                    $('body').loadingModal();
                },
                error: function (xhr) {
                    $.alert({
                        title: 'Error',
                        content: 'there are some error please contact admin !',
                    });
                },
                complete: function () {
                    $('body').loadingModal('destroy');
                },
                success: function (response) {
                    response = JSON.parse(response);
                }
            });
        };

        plugin.convert_data_form = function() {
            var dataArray = $element.find('form[name="form-account"]').serializeArray();
            var output = [];
            dataArray.forEach(function(item) {
                var existing = output.filter(function(v, i) {
                    return v.name == item.name;
                });
                if (existing.length) {
                    var existingIndex = output.indexOf(existing[0]);
                    output[existingIndex].value = output[existingIndex].value.concat(item.value);
                } else {
                    if (typeof item.value == 'string')
                        item.value = [item.value];
                    output.push(item);
                }
            });
            return output;
        };
        plugin.debounce = function(func, wait) {
            var timeout;

            return function() {
                var context = this,
                    args = arguments;

                var executeFunction = function() {
                    func.apply(context, args);
                };

                clearTimeout(timeout);
                timeout = setTimeout(executeFunction, wait);
            };
        };

        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.view_user_account = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('view_user_account')) {
                let plugin = new $.view_user_account(this, options);
                $(this).data('view_user_account', plugin);
            }
        });
    }
})(jQuery);
