<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List vendor");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');

?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("vendor.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-vendor">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-vendor-th nowrap"><?php esc_html_e('Id','wpbookingpro')?></th>
                        <th class="view-list-vendor-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-vendor-th nowrap"><?php esc_html_e('Image','wpbookingpro')?></th>
                        <th class="view-list-vendor-th nowrap"><?php esc_html_e('Number category','wpbookingpro')?></th>
                        <th class="view-list-vendor-th nowrap"><?php esc_html_e('Number service','wpbookingpro')?></th>
                        <th class="view-list-vendor-th nowrap"><?php esc_html_e('Number employee','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="id nowrap"><?php echo (esc_html($item->id)); ?></td>
                        <td class="name nowrap"><?php echo (esc_html(UtilityAlias::get_full_name($item->first_name, $item->last_name))); ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <div>
                                    <img class="vendor-image" src="<?php echo (esc_attr($item->image)); ?>" alt="vendor-image"/>
                                </div>
                            </div>
                        </td>
                        <td class="number-category nowrap"><?php echo (esc_html(count($item->list_category))); ?></td>
                        <td class="number-service nowrap"><?php echo (esc_html(count($item->list_service))); ?></td>
                        <td class="number-employee nowrap"><?php echo (esc_html(count($item->list_employee))); ?></td>
                        <td class="vendor-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("vendor.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Detail','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                <?php esc_html_e('Detail','wpbookingpro');?>
                            </a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_vendor.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-vendor', 'view_list_vendor', array(

), "admin_woopanel/app/assets/js/view_list_vendor.js");
?>