<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');

$item = $this->item;

?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("category.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-category">
            <table id="vendor-category" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Name','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Image','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Published','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Vendor','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_html_e('Id','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($item->list_category as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php echo (esc_html($item->name)); ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <div>
                                    <img class="category-image" src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin()))  ?>/<?php echo (esc_attr($item->image)); ?>" alt="category-image"/>
                                </div>
                            </div>
                        </td>
                        <td class="nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <span class="icon-nb-public" title="<?php esc_attr_e('Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <span class="icon-nb-not-public" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="nowrap">
                            <?php echo (esc_html(isset($item->vendor)?UtilityAlias::get_full_name($item->vendor->first_name, $item->vendor->last_name):'None'))?>
                        </td>
                        <td class="id nowrap" ><?php echo (esc_html($item->id)); ?></td>
                        <td class="wrapper-action nowrap">
                            <div class="button-action">
                                <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("category.form",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="icon-nb-edit"></i></a>
                                <a href="<?php echo($this->permission?UtilityAlias::goToTaskByViewWooPanel("category","category.delete",array('id'=>$item->id)):'javascript:void(0);') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
