<?php

namespace WpBookingProAdminWooPanel\app\views\user;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

class UserView extends View
{
    public function display($tpl)
    {
        $modeluser = Model::getInstance("user");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("user.add");
                ToolBar::delete("user.delete_list");
                ToolBar::_clone("user.clone_list");
                $model = Model::getInstance("users");
                $this->list = $model->getList();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit user');
                ToolBar::apply("user.apply");
                ToolBar::save("user.save");
                ToolBar::cancel("user.cancel");
                ToolBar::back_to_list("user.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modeluser->getItem($id);
                $this->form = $modeluser->getForm();
                break;
        }
        return parent::display($tpl);
    }
}