    <?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdmin\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List sms");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("sms.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-sms">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_attr_e('Account ID','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Auth Token','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Phone register','wpbookingpro')?></th>
                        <th class="nowrap"><?php esc_attr_e('Published','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="account-id nowrap"><?php esc_html_e($item->account_id); ?></td>
                        <td class="auth-token nowrap"><?php esc_html_e($item->auth_token); ?></td>
                        <td class="phone-register nowrap"><?php esc_html_e($item->phone_register); ?></td>
                        <td class="published nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <span class="icon-nb-public" title="<?php esc_attr_e('Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <span class="icon-nb-not-public" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="sms-action">
                            <div class="button-action">
                                <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("sms.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="icon-nb-edit"></i></a>
                                <a href="<?php echo($this->permission?UtilityAlias::goToTaskByViewWooPanel("sms","sms.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_sms.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-sms', 'view_list_sms', array(

), "admin_woopanel/app/assets/js/view_list_sms.js");
?>