<?php

use WpBookingPro\Factory;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
$open_source=Factory::getOpenSource(2);
$product=$open_source->getEcommerce()->get_product($item->open_source_link_id);

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
$check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $item->image);
?>
<div class="wrapper-service-item" data-category_id="<?php esc_html_e($item->category_id) ?>"
     data-id="<?php esc_html_e($item->id) ?>">
    <div class="wrapper-service-content">
        <?php echo (HtmlBackend::render_checkbox($item->id)) ?>
        <div class="service-item-content ">
            <span class="name"><?php esc_html_e($item->name) ?></span>
            <span class="link-product">
                <?php if ($item->open_source_link_id && $product) { ?>
                    <a target="_blank"
                       href="<?php esc_html_e(get_permalink($item->open_source_link_id))  ?>"><?php esc_html_e($product->get_name()); ?></a>
                <?php } else { ?>
                    <?php esc_attr_e('No link open source item','wpbookingpro') ?>
                <?php } ?>
            </span>
        </div>
        <div class="img-box">
            <div>
                <?php if($check_user_demo['is_demo']) {?>
                    <?php if($check_image_size) {?>
                        <img class="service-image" src="<?php echo (esc_url($uploads['baseurl'].'/'.$item->image)) ?>" alt="service-image" />
                    <?php } else {?>
                        <img class="service-image" src="<?php echo (esc_url(Factory::getRootUrlPlugin().$item->image)) ?>" alt="service-image" />
                    <?php } ?>

                <?php } else {?>
                    <img class="service-image" src="<?php echo (esc_url(Factory::getRootUrlPlugin(). $item->image)) ?>" alt="service-image" />
                <?php } ?>
            </div>
        </div>
        <div class="duration-price">
            <div class="block-item">
                <span><?php esc_attr_e('Duration','wpbookingpro') ?>:</span>
                <span class="duration">

                <?php
                if($item->duration * 10  % 2 == 0) {
                    printf("%s:00:00", floor($item->duration));
                } else {
                    printf("%s:30:00", floor($item->duration));
                }
                ?>
            </span>
            </div>
            <div class="block-price">
                <span><?php esc_attr_e('Price','wpbookingpro') ?>:</span>
                <span class="price"><?php echo(HtmlBackend::render_price($item->price)) ?></span>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("service.form",array('id'=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="icon-nb-edit"></i></a>
            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("service","service.delete",array('id'=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="icon-nb-delete"></i></a>
        </div>
    </div>
</div>
