<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List payment");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("payment.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-payment">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','wpbookingpro'); ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_attr_e('Image','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_attr_e('Payment type','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                        <th class="view-list-payment-th nowrap"><?php esc_attr_e('Status','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap"><?php esc_html_e($item->name) ?></td>
                        <td class="image nowrap">
                            <div class="img-box">
                                <div>
                                    <?php $check_image_size = AdminHelper::checkImageData($uploads['baseurl'], $item->image)?>
                                    <?php if($check_user_demo['is_demo']) {?>
                                        <?php if($check_image_size) {?>
                                            <img class="payment-image" src="<?php echo (esc_url($uploads['baseurl'].'/'.$item->image)) ?>" alt="payment-image" />
                                        <?php } else {?>
                                            <img class="payment-image" src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$item->image)) ?>" alt="payment-image" />
                                        <?php } ?>

                                    <?php } else {?>
                                        <img class="payment-image" src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$item->image)) ?>" alt="payment-image" />
                                    <?php } ?>
                                </div>
                            </div>
                        </td>
                        <td class="payment-type nowrap"><?php esc_html_e($item->type) ?></td>
                        <td class="payment-id nowrap"><?php esc_html_e($item->id) ?></td>
                        <td class="payment-status nowrap">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <span class="icon-nb-public" title="<?php esc_attr_e('Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <span class="icon-nb-not-public" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="payment-action">
                            <div class="button-action">
                                <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("payment.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-edit"></i></a>
                                <a href="<?php echo($this->permission?UtilityAlias::goToTaskByViewWooPanel("payment","payment.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_payment.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-payment', 'view_list_payment', array(

), "admin_woopanel/app/assets/js/view_list_payment.js");
?>