<?php

use WpBookingPro\Factory;


?>
<div id="view-payment-block" class="view-payment-form">
    <form action="" method="post" name="admin_woopanel-form" enctype="multipart/form-data">
        <div>
            <ul class="state-tab nav nav-tabs" role="tablist">
                <li role="presentation" class="active">
                    <a href="#detail" aria-controls="home" role="tab" data-toggle="tab">
                        <?php esc_attr_e('Payment details','wpbookingpro') ?>
                    </a>
                </li>
                <li role="presentation">
                    <a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">
                        <?php esc_attr_e('Payments setting','wpbookingpro') ?>
                    </a>
                </li>
            </ul>
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="detail">
                    <div class="row">
                        <div class="col-md-3">
                            <?php echo($this->form->renderField('image')) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <?php echo($this->form->renderField('open_source_payment_id')) ?>
                        </div>
                    </div>
                    <div class="row content-box">

                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <?php echo($this->form->renderField('name')) ?>
                                </div>
                                <div class="col-md-6">
                                    <?php echo($this->form->renderField('published')) ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <?php echo($this->form->renderField('debug')) ?>
                                </div>
                                <div class="col-md-6">
                                    <?php echo($this->form->renderField('is_payment_online')) ?>
                                </div>
                            </div>

                        </div>

                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <?php echo($this->form->renderField('description')) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="settings">
                    <?php
                    $type = $this->item->type;
                    $this->element = new stdClass();
                    $this->element->payment_params = $this->item->params->get('payment_params', "");
                    $configuration_file = WPBOOKINGPRO_PATH_ROOT . "lib/payments/$type/{$type}_configuration.php";
                    ?>
                    <?php if (file_exists($configuration_file)) { ?>
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-bordered">
                                    <?php require_once $configuration_file ?>
                                </table>
                            </div>
                        </div>

                    <?php } ?>
                </div>
            </div>
        </div>
		<?php echo ($this->form->renderField('id')) ?>
        <input type="hidden" name="task" value="state.save">
    </form>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_form_payment.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
