<?php

use WpBookingProAdminWooPanel\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
?>
<tr data-id="<?php esc_html_e($item->id) ?>">
    <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
    <td class="name nowrap"><?php esc_html_e($item->name); ?></td>
    <td class="event-item nowrap">
        <?php if (count((array)$item->list_event)) { ?>
            <?php foreach ((array)$item->list_event as $event) { ?>
                <span class="label label-info"><?php esc_html_e($event->name) ?></span>
            <?php } ?>
        <?php } ?>
    </td>
    <td class="nowrap">
        <?php if ($item->published == 1) { ?>
            <div class="published">
                <span class="icon-nb-public" title="<?php esc_attr_e('Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
            </div>
        <?php } else { ?>
            <div class="unpublished">
                <span class="icon-nb-not-public" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
            </div>
        <?php } ?>
    </td>
    <td>
        <div class="button-action">
            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("package.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>">
                <i class="icon-nb-edit"></i></a>
            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("package",'package.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>">
                <i class="icon-nb-delete"></i></a>
        </div>
    </td>
</tr>
