<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
WpBookingProHtmlWooPanelAlias::load_jquery_library('select2');
WpBookingProHtmlWooPanelAlias::load_jquery_library('loading_js');
ToolBar::setTitle("List Orderpackages");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
<form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("orderpackages.form")) ?>" name="admin_woopanel-form" method="post">
    <div class="view-list-order-package">
        <div class="wrapper-table-package">
            <table id="example" class="display table"">
                <thead>
                    <tr class="header">
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_attr_e('Package','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Customer','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Payment','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Status','wpbookingpro') ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item) { ?>
                        <tr class="row-item-order table-warning" data-order_id="<?php esc_html_e($item->id) ?>">
                            <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                            <td class="nowrap package-name"><?php esc_html_e($item->package->name); ?></td>
                            <td class="nowrap"><?php esc_html_e($item->customer->customer_full_name); ?></td>
                            <td class="nowrap"><?php esc_html_e(HtmlBackend::render_price($item->total)); ?></td>
                            <td class="nowrap">
                                <div class="list-order-status">
                                    <select class="order-status">
                                        <?php foreach ($this->list_order_status as $order_status) { ?>
                                            <option <?php echo((isset($item->open_source_order_status_id)&&$order_status->open_source_order_status_id == $item->open_source_order_status_id) ? ' selected ' : '') ?>
                                                    value="<?php esc_html_e($order_status->open_source_order_status_id); ?>"><?php esc_html_e($order_status->title); ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </td>
                            <td>
                                <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("orderpackages.form",array('id'=>$item->id))) ?>" class="btn btn-primary btn-detail" title="<?php esc_attr_e('Detail','wpbookingpro')?>"><?php esc_attr_e('Detail','wpbookingpro')?></a>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/list_view_order_package.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-order-package', 'list_view_order_package', array(

), "admin_woopanel/app/assets/js/list_view_order_package.js");
?>