<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_location.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List locations");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
WpBookingProHtmlWooPanelAlias::load_jquery_library('select2');

$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);

?>
<?php ?>
    <form action="" name="admin_woopanel-form" method="post">
        <div class="view-list-location">
            <div class="row">
                <div class="col-md-3">
                    <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                    <select  id="searchByVendor" name="user_id">
                        <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                        <?php foreach ($this->list_vendor as $vendor_item) {?>
                            <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                            </option>
                        <?php }?>
                    </select>
                </div>
            </div>
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Name','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Address','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Phone number','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('State country','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="location-name">
                            <h4><?php echo ($item->name); ?></h4>
                        </td>
                        <td class="location-address">
                            <p><?php echo ($item->address); ?> </p>
                        </td>
                        <td class="location-phone">
                            <?php
                                $mobile = isset($item->mobile)?$item->mobile:'';
                                if($mobile['0'] == 0) {
                                    $mobile = substr($mobile,1);
                                }
                                $phonecode = isset($item->phonecode)?$item->phonecode:'';
                                echo (esc_html('+'.$phonecode . $mobile));
                            ?>
                        </td>
                        <td class="location-country-name"><?php echo ($item->state_name.' - '.$item->country_name); ?> </td>
                        <td class="location-action">
                            <div class="button-action">
                                <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("location.form",array("id"=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-edit"></i></a>
                                <a href="<?php echo($this->permission?UtilityAlias::goToTaskByViewWooPanel("location",'location.delete',array("id"=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addScriptApplySelector('.view-list-location', 'view_list_location', array(

), "admin_woopanel/app/assets/js/view_list_location.js");
?>