<?php

namespace WpBookingProAdminWooPanel\app\views\location;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

class LocationView extends View
{
    public function display($tpl)
    {
        $modellocation = Model::getInstance("location");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("location.add");
                ToolBar::delete("location.delete_list");
                ToolBar::_clone('location.clone_list');
                $model = Model::getInstance("locations");
                $this->list = $model->getList();
                $modelVendors = Model::getInstance('vendors');
                $this->list_vendor = $modelVendors->getListVendor();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit locations');
                ToolBar::save("location.save");
                ToolBar::cancel('location.cancel');
                ToolBar::apply('location.apply');
                ToolBar::back_to_list('location.back_to_list');
                $id = $input->getInt('id', 0);
                $this->item = $modellocation->getItem($id);
                $this->form = $modellocation->getForm();
                break;
        }
        return parent::display($tpl);
    }
}