<?php

use WpBookingProAdminWooPanel\app\Html\HtmlBackend;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$item = $this->item;
?>
<tr data-id="<?php esc_html_e($item->id) ?>" class="list-rate-title">
    <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
    <td class="name nowrap item-name"><?php esc_html_e($item->name) ?></td>
    <td class="name nowrap"><?php esc_html_e($item->total_order) ?></td>
    <td class="nowrap"><?php esc_html_e($item->total_person) ?>/<?php esc_html_e($item->max_allowed_person) ?></td>
    <td class="nowrap"><?php esc_html_e($item->min_allowed_person) ?>-<?php esc_html_e($item->max_allowed_person) ?></td>
    <td class="recurring">
        <?php if(isset($item->recurring)) {?>
            <i class="icon-nb-back"></i> <span><?php esc_attr_e('Yes','wpbookingpro')?></span>
        <?php } else {?>
            <i class="icon-nb-back"></i> <span><?php esc_attr_e('No','wpbookingpro')?></span>
        <?php }?>
    </td>
    <td class="open_date nowrap"><?php echo(HtmlBackend::render_date(isset($item->open_date)?$item->open_date:"","Y-m-d")); ?></td>
    <td class="close_date nowrap"><?php echo(HtmlBackend::render_date(isset($item->close_date)?$item->close_date:"","Y-m-d")); ?></td>
    <td class="published">
        <?php if(isset($item->published)) {?>
            <span class="label label-success"><?php esc_attr_e('Open','wpbookingpro')?></span>
        <?php } else {?>
            <span class="label label-danger"><?php esc_attr_e('Close','wpbookingpro')?></span>
        <?php }?>
    </td>
    <td class="item-id nowrap"><?php esc_html_e($item->id) ?></td>
    <td class="event-button">
        <div class="action-button">
            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("event.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>">
                <i class="icon-nb-edit"></i>
            </a>
            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel("event",'event.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>">
                <i class="icon-nb-delete"></i>
            </a>
        </div>
    </td>
</tr>
