<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Event");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("event.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-event">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="nowrap"><?php esc_attr_e('Name','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Total order','wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_attr_e('Spots','wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_attr_e('Min max', 'wpbookingpro') ?></th>
                        <th class="hidden-md-up nowrap"><?php esc_attr_e('Recurring','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Booking opens','wpbookingpro') ?> </th>
                        <th class="nowrap"><?php esc_attr_e('Booking close','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Status','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('ID','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 0; ?>
                    <?php foreach ($this->list as $item) { ?>
                        <?php
                            $item->index = $i;
                            $this->item = $item;
                            $this->loadTemplate('list_item');
                            $i++;
                        ?>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_event.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-event', 'view_list_event', array(

), "admin_woopanel/app/assets/js/view_list_event.js");
?>