<?php
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProAdmin\app\Html\HtmlBackend;
use WpBookingPro\Language\Text;
$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customize");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("customize.form")) ?>" name="admin_woopanel-form" method="post">
        <div class="view-list-customize">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th></th>
                        <th><?php esc_html_e('Table','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Label','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Field','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Type','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Backend','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Frontend','wpbookingpro'); ?></th>
                        <th><?php esc_html_e('Default value','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="customize-table">
                            <?php echo (esc_html (ucfirst($item->table_view))); ?>
                        </td>
                        <td class="customize-label">
                            <?php echo (esc_html ($item->label_field)); ?>
                        </td>
                        <td class="customize-field">
                            <?php echo (esc_html ($item->field_name)); ?>
                        </td>
                        <td class="customize-type">
                            <?php echo (esc_html ($item->type)); ?>
                        </td>
                        <td class="customize-backend">
                            <?php if ($item->backend == 1) { ?>
                                <div class="published">
                                    <span class="icon-nb-public" title="<?php esc_attr_e('Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <span class="icon-nb-not-public" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-frontend">
                            <?php if ($item->frontend == 1) { ?>
                                <div class="published">
                                    <span class="icon-nb-public" title="<?php esc_attr_e('Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <span class="icon-nb-not-public" title="<?php esc_attr_e('Not Public','wpbookingpro')?>"><span class="path1"></span><span class="path2"></span></span>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="customize-type">
                            <?php echo (esc_html ($item->default_value)); ?>
                        </td>

                        <td class="customize-action">
                            <div class="button-action">
                                <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("customize.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-edit"></i></a>
                                <a href="<?php echo($this->permission?UtilityAlias::goToTaskByViewWooPanel("customize","customize.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="customize.add">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_customize.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-customize', 'view_list_customize', array(

), "admin_woopanel/app/assets/js/view_list_customize.js");
?>