<?php

namespace WpBookingProAdminWooPanel\app\views\customize;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

class CustomizeView extends View
{
    public function display($tpl)
    {
        $modelcustomize = Model::getInstance("customize");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("customize.add");
                ToolBar::delete("customize.delete_list");
                ToolBar::_clone("customize.clone_list");
                $model = Model::getInstance("customizes");
                $this->list = $model->getList();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit customize');
                ToolBar::apply("customize.apply");
                ToolBar::save("customize.save");
                ToolBar::cancel("customize.cancel");
                ToolBar::back_to_list("customize.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelcustomize->getItem($id);
                $this->form = $modelcustomize->getForm();

                break;
        }
        return parent::display($tpl);
    }
}