<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Customer");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
WpBookingProHtmlWooPanelAlias::load_jquery_library('select2');

$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);

?>
<?php ?>
    <form action="" name="admin_woopanel-form" method="post">
        <div class="view-list-customer">
            <div class="row">
                <div class="col-md-3">
                    <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                    <select  id="searchByVendor" name="user_id">
                        <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                        <?php foreach ($this->list_vendor as $vendor_item) {?>
                            <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                            </option>
                        <?php }?>
                    </select>
                </div>
            </div>
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"><?php esc_attr_e('Index','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Customer','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Wordpress user','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Phone','wpbookingpro') ?></th>
                        <th ><?php esc_attr_e('Note','wpbookingpro') ?></th>
                        <th class="nowrap"><?php esc_attr_e('Birthday','wpbookingpro') ?></th>
                        <th class="nowrap"></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="name nowrap">
                            <h4><?php esc_html_e($item->full_name); ?></h4>
                            <p><?php esc_html_e($item->email); ?></p>
                        </td>
                        <td class="wp_id nowrap">
                            <?php
                            $opensource_user_id = $item->opensource_user_id;
                            $name = "";
                            if ($opensource_user_id) {
                                $user = get_user_by('id', $item->opensource_user_id);
                                $name = $user ? $user->get('user_login') : '';
                            }
                            ?>
                            <?php esc_html_e($name); ?></td>
                        <td class="mobile nowrap">
                            <?php
                            $mobile = isset($item->mobile)?$item->mobile:'';
                            if($mobile['0'] == 0) {
                                $mobile = substr($mobile,1);
                            }
                            $phonecode = isset($item->phonecode)?$item->phonecode:'';
                            echo (esc_html('+'.$phonecode . $mobile));
                            ?>
                        </td>
                        <td class="note"><p><?php esc_html_e($item->note_internal); ?></p></td>
                        <td class="birthday nowrap"><?php esc_html_e($item->birth_day); ?></td>
                        <td class="customer-action">
                            <div class="button-action">
                                <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("customer.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-edit"></i></a>
                                <a href="<?php echo($this->permission?UtilityAlias::goToTaskByViewWooPanel("customer","customer.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>>
                                    <i class="icon-nb-delete"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_customer.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-customer', 'view_list_customer', array(

), "admin_woopanel/app/assets/js/view_list_customer.js");
?>