<?php

namespace WpBookingProAdminWooPanel\app\views\currency;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

class CurrencyView extends View
{
    public function display($tpl)
    {
        $modelcurrency = Model::getInstance("currency");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("currency.add");
                ToolBar::delete("currency.delete_list");
                ToolBar::_clone("currency.clone_list");
                $model = Model::getInstance("currencies");
                $this->list = $model->getList();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit currency');
                ToolBar::apply("currency.apply");
                ToolBar::save("currency.save");
                ToolBar::cancel("currency.cancel");
                ToolBar::back_to_list("currency.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelcurrency->getItem($id);
                $this->form = $modelcurrency->getForm();
                break;
        }
        return parent::display($tpl);
    }
}