<?php

namespace WpBookingProAdminWooPanel\app\views\coupon;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

class CouponView extends View
{
    public function display($tpl)
    {
        $modelcoupon = Model::getInstance("coupon");
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::add("coupon.add");
                ToolBar::delete("coupon.delete_list");
                ToolBar::_clone("coupon.clone_list");
                $model = Model::getInstance("coupons");
                $this->list = $model->getList();
                $modelVendors = Model::getInstance('vendors');
                $this->list_vendor = $modelVendors->getListVendor();
                $this->permission = AdminHelper::setPermission();
                break;
            case "form":
                ToolBar::setTitle('Edit coupon');
                ToolBar::apply("coupon.apply");
                ToolBar::save("coupon.save");
                ToolBar::cancel("coupon.cancel");
                ToolBar::back_to_list("coupon.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $modelcoupon->getItem($id);
                $this->form = $modelcoupon->getForm();
                break;
        }
        return parent::display($tpl);
    }
}