<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingPro\Language\Text;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('icheck');
ToolBar::setTitle("List category");
WpBookingProHtmlWooPanelAlias::load_jquery_library('datatables');
WpBookingProHtmlWooPanelAlias::load_jquery_library('select2');

$input = FactoryAlias::getInput();
$user_id = $input->getInt('user_id',0);

$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
<?php ?>
    <form action="" name="admin_woopanel-form" method="post">
        <div class="view-list-category">
            <div class="row">
                <div class="col-md-3">
                    <h5><?php esc_html_e('Filter by vendor','wpbookingpro');?></h5>
                    <select  id="searchByVendor" name="user_id">
                        <option value=''>-- <?php esc_html_e('Select vendor','wpbookingpro');?>--</option>
                        <?php foreach ($this->list_vendor as $vendor_item) {?>
                            <option value="<?php echo (esc_attr($vendor_item->id)) ?>" <?php echo (esc_attr($user_id == $vendor_item->id ? 'selected':''))?> >
                                <?php echo (esc_html(UtilityAlias::get_full_name($vendor_item->first_name, $vendor_item->last_name)))?>
                            </option>
                        <?php }?>
                    </select>
                </div>
            </div>
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th class="nowrap"></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Name','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Image','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('Description','wpbookingpro')?></th>
                        <th class="view-list-category-th nowrap"><?php esc_attr_e('ID','wpbookingpro')?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="category-name nowrap"><?php esc_html_e($item->name); ?></td>
                        <td class="category-image nowrap">
                            <div class="img-box">
                                <div>
                                    <?php $check_image_size =  AdminHelper::checkImageData($uploads['baseurl'], $item->image)?>
                                    <?php if($check_user_demo['is_demo']) {?>
                                        <?php if($check_image_size) {?>
                                            <img class="category-image" src="<?php echo (esc_url($uploads['baseurl'].'/'.$item->image)); ?>" alt="category-image"/>
                                        <?php } else {?>
                                            <img class="category-image" src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin().$item->image)); ?>" alt="category-image"/>
                                        <?php } ?>

                                    <?php }else {?>
                                        <img class="category-image" src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin() . $item->image)); ?>" alt="category-image"/>
                                    <?php }?>
                                </div>
                            </div>
                        </td>
                        <td class="category-description nowrap">
                            <?php esc_html_e($item->description); ?>
                        </td>
                        <td class="category-id nowrap"><?php esc_html_e($item->id); ?></td>
                        <td class="category-action">
                            <a href="<?php echo($this->permission?UtilityAlias::getBackendWooPanelGoToLink("category.form",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="icon-nb-edit"></i></a>
                            <a href="<?php echo($this->permission?UtilityAlias::goToTaskByViewWooPanel("category","category.delete",array('id'=>$item->id)):'javascript:void(0)') ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>" <?php echo (esc_attr($this->permission?'':'disabled'))?>><i class="icon-nb-delete"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="">
    </form>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_category.less');
$doc->addStyleSheet('admin_woopanel/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-category', 'view_list_category', array(

), "admin_woopanel/app/assets/js/view_list_category.js");
?>