<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlWooPanel as WpBookingProHtmlWooPanelAlias;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

$doc = FactoryAlias::getDocument();
WpBookingProHtmlWooPanelAlias::load_jquery_library('moment');
WpBookingProHtmlWooPanelAlias::load_jquery_library('fullcalendar');
WpBookingProHtmlWooPanelAlias::load_jquery_library('loading_js');
WpBookingProHtmlWooPanelAlias::load_jquery_library('confirm');
WpBookingProHtmlWooPanelAlias::load_jquery_library('validate');
ToolBar::setTitle("Calendar");
$list_employee = $this->list_employee;
$appConfig = FactoryAlias::getAppConfig();
$request_payment = $appConfig->get('request_payment','');
$check_user_demo = AdminHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
    <div class="view-list-calendar">
        <div class="wrapper-employee">
           <ul class="list-employee">
               <li class="employee-item active" data-employee_id="0">
                   <div class="wrapper-img">
                       <div class="block-image">
                           <span><?php esc_attr_e('All', 'wpbookingpro');?></span>
                       </div>
                   </div>
                   <p class="text"><?php esc_attr_e('All employees', 'wpbookingpro');?></p>
               </li>
               <?php foreach ($list_employee as $employee) {?>
                   <li class="employee-item" data-employee_id="<?php esc_html_e($employee->id);?>">
                       <div class="wrapper-img">
                           <div class="img-box">
                               <div>
                                   <?php if($check_user_demo['is_demo']) {?>
                                       <img src="<?php echo (esc_url($uploads['baseurl'].'/' .$employee->cover));?>" alt="employee">
                                    <?php } else {?>
                                       <img src="<?php echo (esc_url(FactoryAlias::getRootUrlPlugin() .$employee->cover ));?>" alt="employee">
                                   <?php }?>
                               </div>
                           </div>
                       </div>
                       <p class="employee-name"><?php echo($employee->first_name.' '.$employee->last_name);?></p>
                   </li>
                <?php }?>
           </ul>
        </div>
        <div id="calendar"></div>
        <form  action=""  method="post" role="form" name="client-form" enctype="multipart/form-data">
            <div id="calendarModal" class="modal fade" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span> <span class="sr-only"><?php esc_html_e('Close','wpbookingpro') ?></span></button>
                            <h4 id="modalTitle" class="modal-title"><?php esc_html_e('Edit Event','wpbookingpro') ?></h4>
                        </div>
                        <div id="modalBody" class="modal-body">

                            <?php
                            $field = $this->form->getField('calendar');
                            echo ($field->input);
                            ?>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><?php esc_html_e('Close','wpbookingpro') ?></button>
                            <button type="button"  class="btn btn-danger btn-remove-order"  <?php echo (esc_attr($this->permission?'':'disabled'))?>  ><?php esc_html_e('Remove','wpbookingpro') ?></button>
                            <button type="button"  class="btn btn-success btn-edit-order" <?php echo (esc_attr($this->permission?'':'disabled'))?> ><?php esc_html_e('Edit','wpbookingpro') ?></button>
                            <button type="button"  class="btn btn-info btn-request-payment" data-order_id="" <?php echo (esc_attr($this->permission?'':'disabled'))?>  <?php echo(esc_attr($request_payment == 'manual'?'':'disabled')) ?> ><?php esc_html_e('Request payment','wpbookingpro') ?></button>
                        </div>
                    </div>
                </div>
            </div>
            <input type="hidden" name="task">
            <input type="hidden" name="order_id">
            <input type="hidden" name="order_detail_id">
            <input type="hidden" name="service_id">
            <input type="hidden" name="employee_id">
            <input type="hidden" name="link_redirect" value="<?php echo(Utility::getBackendWooPanelGoToLink("calendar.list")) ?>">

        </form>
    </div>
<?php
$doc->addLessStyleSheet('admin_woopanel/app/assets/less/view_list_calendar.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.view-list-calendar','view_list_calendar',array(
    "list_order"=>  $this->list,
    "list_service"=>$this->list_service,
    "is_demo" => $check_user_demo['is_demo'],
    "link_image_demo" => $uploads['baseurl'].'/'
),'admin_woopanel/app/assets/js/view_list_calendar.js');
?>