<?php

namespace WpBookingProAdminWooPanel\app\views\appointment;

use WpBookingPro\Html\ToolBar;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingProAdminWooPanel\app\helpers\AdminHelper;

class AppointmentView extends View
{
    public function display($tpl)
    {
        $input = FactoryAlias::getInput();
        switch ($tpl) {
            case "list":
                ToolBar::set_currency("appointment.set_currency");
                ToolBar::delete("appointment.delete_list");
                ToolBar::_clone("appointment.clone_list");
                $model = Model::getInstance("appointments");
                $this->permission = AdminHelper::setPermission();
                $model = Model::getInstance("appointments");
                $this->list = $model->getList();
                $modelOrderStatus = Model::getInstance('orderstatuss');
                $modelVendors = Model::getInstance('vendors');
                $this->list_vendor = $modelVendors->getListVendor();
                $this->list_order_status = $modelOrderStatus->getList();
                $modelCurrencies = Model::getInstance('currencies');
                $this->list_currency = $modelCurrencies->getList();
                break;
            case "form":
                $model = Model::getInstance("appointment");
                ToolBar::setTitle('Appointment Details');
                ToolBar::cancel("appointment.cancel");
                ToolBar::back_to_list("appointment.back_to_list");
                $id = $input->getInt('id', 0);
                $this->item = $model->getItem($id);
                break;
        }
        return parent::display($tpl);
    }
}