<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\ToolBar;
use WpBookingPro\Html\WpBookingProHtmlBackend as WpBookingProHtmlBackendAlias;
use WpBookingPro\Utilities\Utility as UtilityAlias;
use WpBookingProAdminWooPanel\app\Html\HtmlBackend;
use WpBookingPro\Language\Text;
$doc = FactoryAlias::getDocument();
WpBookingProHtmlBackendAlias::load_jquery_library('icheck');
ToolBar::setTitle("List Activities");
WpBookingProHtmlBackendAlias::load_jquery_library('datatables');
?>
<?php ?>
    <form action="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("activities.form")) ?>" name="admin-form" method="post">
        <div class="view-list-activities">
            <table id="example" class="display table">
                <thead>
                    <tr>
                        <th><?php esc_attr_e('Index','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Activity name','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Image','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Publish','wpbookingpro'); ?></th>
                        <th><?php esc_attr_e('Description','wpbookingpro'); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->list as $item){?>
                    <tr>
                        <td class="sorting_1"><?php echo (HtmlBackend::render_checkbox($item->id)) ?></td>
                        <td class="activity-name">
                            <h4>
                                <?php echo ($item->name); ?>
                            </h4>
                        </td>
                        <td class="activity-image">
                            <div class="img-box">
                                <div>
                                    <img src="<?php echo(FactoryAlias::getRootUrlPlugin().'/'.$item->image) ?>">
                                </div>
                            </div>
                        </td>
                        <td class="activity-published">
                            <?php if ($item->published == 1) { ?>
                                <div class="published">
                                    <i class="fas fa-check-square" title="Public"></i>
                                </div>
                            <?php } else { ?>
                                <div class="unpublished">
                                    <i class="far fa-times-circle" title="Not-Public"></i>
                                </div>
                            <?php } ?>
                        </td>
                        <td class="activity-description">
                            <div>
                                <?php echo ($item->description); ?>
                            </div>
                        </td>
                        <td class="activity-action">
                            <a href="<?php echo(UtilityAlias::getBackendWooPanelGoToLink("activities.form",array("id"=>$item->id))) ?>" class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro')?>"><i class="fas fa-edit"></i></a>
                            <a href="<?php echo(UtilityAlias::goToTaskByViewWooPanel('activities','activity.delete',array("id"=>$item->id))) ?>" class="btn-delete" title="<?php esc_attr_e('Delete','wpbookingpro')?>"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <input type="hidden" name="task" value="activities.add">
    </form>
<?php
$doc->addLessStyleSheet('admin/app/assets/less/list_activity.less');
$doc->addScriptApplySelector('.view-list-activities', 'view_list_activities', array(

), "admin/app/assets/js/view_list_activities.js");
?>