<?php
namespace WpBookingProAdminWooPanel\app\models;


defined('_WPBOOKINGPRO_EXEC') or die;


use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;
use WpBookingProAdmin\app\helpers\AdminHelper;

class VendorModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "vendor";
    /**
     * @var string
     */
    public $table_name = "user";

    public function getListCategoryByUserID($user_id='') {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('id')
            ->from($this->getTableName('category'))
            ->where('user_id='.(int)$user_id)
        ;
        $list_category_id = $db->setQuery($query)->loadColumn();
        return $list_category_id;
    }

    public function getInfoVendor($id='') {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->clear()
            ->select('user.*')
            ->from($this->getTableName('user').' AS user')
            ->leftJoin($this->getTableName('groupuser').' AS groupuser ON groupuser.id=user.group_user_id')
            ->where('groupuser.alias='.$query->quote('vendor'))
            ->where('user.id='.(int)$id)
        ;
        $vendor = $db->setQuery($query)->loadObject();

        $query->clear()
            ->select('*')
            ->from($this->getTableName('category'))
            ->where('user_id='.(int)$vendor->id)
        ;
        $list_category = $db->setQuery($query)->loadObjectList();
        foreach ($list_category as &$category) {
            $query->clear()
                ->select('*')
                ->from($this->getTableName('user'))
                ->where('id='.(int)$category->user_id)
            ;
            $category->vendor = $db->setQuery($query)->loadObject();
        }
        $vendor->list_category = $list_category;

        $query->clear()
            ->select('*')
            ->from($this->getTableName('service'))
            ->where('user_id='.(int)$vendor->id)
        ;
        $list_service = $db->setQuery($query)->loadObjectList();
        $vendor->list_service = $list_service;

        $query->clear()
            ->select('*')
            ->from($this->getTableName('employee'))
            ->where('user_id='.(int)$vendor->id)
        ;
        $list_employee = $db->setQuery($query)->loadObjectList();
        $vendor->list_employee = $list_employee;
        return  $vendor;
    }


}
