<?php
namespace WpBookingProAdminWooPanel\app\models;


defined('_WPBOOKINGPRO_EXEC') or die;


use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class PermissionModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "permission";
    /**
     * @var string
     */
    public $table_name = "permission";

    public static function getPermission(){
        if(is_user_logged_in()) {
            $user_id = get_current_user_id();
            $db = Factory::getDBO();
            $query = $db->getQuery(true);
            $query->clear()
                ->select('groupuser.id')
                ->from(Utility::getTableName('groupuser').' AS groupuser')
                ->leftJoin(Utility::getTableName('user').' AS user ON user.group_user_id=groupuser.id')
                ->where('user.open_source_user_id='.(int)$user_id)
            ;
            $group_id = $db->setQuery($query)->loadResult();

            $query->clear()
                ->select('*')
                ->from(Utility::getTableName('permission'))
                ->where('group_user_id='.(int)$group_id)
            ;
            $permission = $db->setQuery($query)->loadObject();
            return $permission;
        }
        return array();
    }

}
