<?php
namespace WpBookingProAdminWooPanel\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Filesystem\File as FileAlias;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
use WpBookingPro\Utilities\Utility;

class CustomizeModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "customize";
    /**
     * @var string
     */
    public $table_name = "customize";

    public function save($data = array())
    {
        $is_new = (isset($data['id']) && $data['id'] != '' && is_numeric($data['id']))?false:true;
        $item= parent::save($data); // TODO: Change the autogenerated stub
        if($is_new){
            $db=Factory::getDBO();
            $table=Utility::getTableName($item->table_view);
            switch ($item->type){
                case "boolean":
                    $db->setQuery("ALTER TABLE {$table} ADD `{$item->field_name}` INT NOT NULL;")->execute();
                    break;
                case "select":
                case "text":
                    $db->setQuery("ALTER TABLE {$table} ADD `{$item->field_name}` VARCHAR(255) NOT NULL;")->execute();
                    break;
                case "editor":
                    $db->setQuery("ALTER TABLE {$table} ADD `{$item->field_name}` MEDIUMTEXT NOT NULL;")->execute();
                    break;

            }
        }
        return $item;
    }


}
