<?php
namespace WpBookingProAdminWooPanel\app\models;
defined('_WPBOOKINGPRO_EXEC') or die;

use WpBookingPro\Factory;
use WpBookingPro\Mvc\Model\ModelForm;
use WpBookingPro\Form\Form;
use WpBookingPro\Mvc\Model\ModelList;
use WpBookingPro\Registry\Registry;
class CustomersModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "customers";
    /**
     * @var string
     */
    public $table_name = "customer";
    public function getListQuery()
    {
        $input = Factory::getInput();
        $user_id  = $input->getInt('user_id',0);

        $query=$this->db->getQuery(true);
        $query->select("a.*")
            ->from($this->getTableName().' AS a')

        ;
        if($user_id > 0) {
            $query->where('a.user_id='.(int)$user_id);
        }
        $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));

        return $query;
    }

    public function getList()
    {
        $list = parent::getList(); // TODO: Change the autogenerated stub
        foreach ($list as $item) {
            $item->full_name = "{$item->first_name} {$item->last_name}";
        }
        return $list;
    }
    public function get_list_customer_in_year()
    {
        $now = Factory::getDate();
        $now1 = $now->modify('-12 month');
        $query = $this->_db->getQuery(true);
        $query->select('customer1.*')
            ->select('MONTH(customer1.created_date) AS month')
            ->from($this->getTableName('customer') . ' AS customer1')
            ->where('customer1.created_date>=' . $query->quote($now1->toSql()));
        $list = $this->_db->setQuery($query)->loadObjectList();
        foreach ($list as $item) {
            $item->full_name = "{$item->first_name} {$item->last_name}";
        }
        return $list;
    }


}
