<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$timezoneModel = Model::getInstance('timezones');
$list_timezone = $timezoneModel->getList();

?>
    <div id="<?php esc_attr_e($id_by_name) ?>"
         class="<?php esc_attr_e($class); ?> field-timezone-<?php esc_attr_e($name_format) ?> field-timezone">
        <select class="form-control list-timezone" <?php echo ($multiple ? ' multiple ' : ""); ?>>
            <option value=""> <?php esc_html_e('Select timezone','wpbookingpro') ?></option>
			<?php foreach ($list_timezone as $timezone) { ?>
                <option <?php echo ($timezone->timezone == $value ? " selected " : "") ?>
                        value="<?php esc_attr_e($timezone->timezone); ?>"><?php esc_html_e($timezone->timezone); ?></option>
			<?php } ?>
        </select>
        <input type="hidden" name="<?php esc_attr_e($name); ?>">
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/timezone/timezone.less');
$doc->addScriptApplySelector('.field-timezone','field_timezone',array(
    "field_name"=>  $name,
    "value"=> $value
),'admin_woopanel/app/layouts/WooBooking/form/field/timezone/timezone.jquery.js');
