<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlWooPanel;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingProAdmin\app\helpers\AdminHelper;

defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);

$modelCurrencies = Model::getInstance('currencies');
$list_currency = $modelCurrencies->getList();


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-setcurrency-<?php echo (esc_attr($name_format)) ?> field-setcurrency">
        <select name="<?php echo (esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : ""); ?> class="form-control list-setcurrency">
            <option value="" disabled> <?php esc_html_e('Select currency','wpbookingpro') ?></option>
			<?php foreach ($list_currency as $currency) { ?>
                <option <?php echo (esc_attr($currency->unit_currency == $value ? " selected " : "")) ?>
                        value="<?php echo (esc_attr($currency->unit_currency)); ?>"><?php echo (esc_html($currency->unit_currency)); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlWooPanel::load_jquery_library('select2');
$doc->addLessStylesheet('admin_woopanel/app/layouts/WooBooking/form/field/setcurrency/setcurrency.less');
$doc->addScriptApplySelector('.field-setcurrency','field_setcurrency',array(
    "field_name"=>  $name,
),'admin_woopanel/app/layouts/WooBooking/form/field/setcurrency/setcurrency.jquery.js');
