<?php
use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlBackend;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Utilities\Utility;
defined('_WPBOOKINGPRO_EXEC') or die;
extract($displayData);

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);

$week = array('Monday','Tuesday' ,'Wednesday' ,'Thursday' ,'Friday','Saturday','Sunday');

if(isset($value) && trim($value) != '') {
    $arr_value= json_decode($value);
} else {
    $arr_value=array();
}
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> element-field-selectday">
        <?php foreach ($week as $dayName) {?>
            <label class="name-day-of-week">
                <input type='checkbox' class="day-of-week" value="<?php esc_html_e($dayName);?>" <?php echo(in_array($dayName,$arr_value)? 'checked':''); ?>/>
                <?php esc_html_e($dayName);?>
            </label>
        <?php }?>
        <input type="hidden" name="<?php esc_html_e($name);?>">
    </div>
<?php
$doc = Factory::getDocument();
WpBookingProHtmlBackend::load_jquery_library('icheck');
$doc->addLessStyleSheet('admin_woopanel/app/layouts/WooBooking/form/field/selectday/selectday.less');
$doc->addScriptApplySelector('.element-field-selectday','field_selectday',array(
        'input_name'=>$name,
        'value'=>$arr_value
),'admin_woopanel/app/layouts/WooBooking/form/field/selectday/selectday.jquery.js');
